package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.DataAccessRoleArn
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class JobExecutionSettings(
    allowDeferredExecution: Option[Boolean] = None,
    dataAccessRoleArn: Option[DataAccessRoleArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.JobExecutionSettings = {
    import JobExecutionSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.JobExecutionSettings
      .builder()
      .optionallyWith(
        allowDeferredExecution.map(value => value: java.lang.Boolean)
      )(_.allowDeferredExecution)
      .optionallyWith(
        dataAccessRoleArn.map(value =>
          DataAccessRoleArn.unwrap(value): java.lang.String
        )
      )(_.dataAccessRoleArn)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.JobExecutionSettings.ReadOnly =
    zio.aws.transcribe.model.JobExecutionSettings.wrap(buildAwsValue())
}
object JobExecutionSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.JobExecutionSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.JobExecutionSettings =
      zio.aws.transcribe.model.JobExecutionSettings(
        allowDeferredExecution.map(value => value),
        dataAccessRoleArn.map(value => value)
      )
    def allowDeferredExecution: Option[Boolean]
    def dataAccessRoleArn: Option[DataAccessRoleArn]
    def getAllowDeferredExecution: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("allowDeferredExecution", allowDeferredExecution)
    def getDataAccessRoleArn: ZIO[Any, AwsError, DataAccessRoleArn] =
      AwsError.unwrapOptionField("dataAccessRoleArn", dataAccessRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.JobExecutionSettings
  ) extends zio.aws.transcribe.model.JobExecutionSettings.ReadOnly {
    override val allowDeferredExecution: Option[Boolean] =
      scala.Option(impl.allowDeferredExecution()).map(value => value: Boolean)
    override val dataAccessRoleArn: Option[DataAccessRoleArn] = scala
      .Option(impl.dataAccessRoleArn())
      .map(value =>
        zio.aws.transcribe.model.primitives.DataAccessRoleArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.JobExecutionSettings
  ): zio.aws.transcribe.model.JobExecutionSettings.ReadOnly = new Wrapper(impl)
}
