package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeLanguageModelResponse(
    languageModel: Option[zio.aws.transcribe.model.LanguageModel] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.DescribeLanguageModelResponse = {
    import DescribeLanguageModelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.DescribeLanguageModelResponse
      .builder()
      .optionallyWith(languageModel.map(value => value.buildAwsValue()))(
        _.languageModel
      )
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.DescribeLanguageModelResponse.ReadOnly =
    zio.aws.transcribe.model.DescribeLanguageModelResponse.wrap(buildAwsValue())
}
object DescribeLanguageModelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.DescribeLanguageModelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.DescribeLanguageModelResponse =
      zio.aws.transcribe.model.DescribeLanguageModelResponse(
        languageModel.map(value => value.asEditable)
      )
    def languageModel: Option[zio.aws.transcribe.model.LanguageModel.ReadOnly]
    def getLanguageModel
        : ZIO[Any, AwsError, zio.aws.transcribe.model.LanguageModel.ReadOnly] =
      AwsError.unwrapOptionField("languageModel", languageModel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.DescribeLanguageModelResponse
  ) extends zio.aws.transcribe.model.DescribeLanguageModelResponse.ReadOnly {
    override val languageModel
        : Option[zio.aws.transcribe.model.LanguageModel.ReadOnly] = scala
      .Option(impl.languageModel())
      .map(value => zio.aws.transcribe.model.LanguageModel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.DescribeLanguageModelResponse
  ): zio.aws.transcribe.model.DescribeLanguageModelResponse.ReadOnly =
    new Wrapper(impl)
}
