package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.TranscriptionJobName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteTranscriptionJobRequest(
    transcriptionJobName: TranscriptionJobName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.DeleteTranscriptionJobRequest = {
    import DeleteTranscriptionJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.DeleteTranscriptionJobRequest
      .builder()
      .transcriptionJobName(
        TranscriptionJobName.unwrap(transcriptionJobName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.DeleteTranscriptionJobRequest.ReadOnly =
    zio.aws.transcribe.model.DeleteTranscriptionJobRequest.wrap(buildAwsValue())
}
object DeleteTranscriptionJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.DeleteTranscriptionJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.DeleteTranscriptionJobRequest =
      zio.aws.transcribe.model
        .DeleteTranscriptionJobRequest(transcriptionJobName)
    def transcriptionJobName: TranscriptionJobName
    def getTranscriptionJobName: ZIO[Any, Nothing, TranscriptionJobName] =
      ZIO.succeed(transcriptionJobName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.DeleteTranscriptionJobRequest
  ) extends zio.aws.transcribe.model.DeleteTranscriptionJobRequest.ReadOnly {
    override val transcriptionJobName: TranscriptionJobName =
      zio.aws.transcribe.model.primitives
        .TranscriptionJobName(impl.transcriptionJobName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.DeleteTranscriptionJobRequest
  ): zio.aws.transcribe.model.DeleteTranscriptionJobRequest.ReadOnly =
    new Wrapper(impl)
}
