package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.ModelName
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateLanguageModelRequest(
    languageCode: zio.aws.transcribe.model.CLMLanguageCode,
    baseModelName: zio.aws.transcribe.model.BaseModelName,
    modelName: ModelName,
    inputDataConfig: zio.aws.transcribe.model.InputDataConfig,
    tags: Option[Iterable[zio.aws.transcribe.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.CreateLanguageModelRequest = {
    import CreateLanguageModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.CreateLanguageModelRequest
      .builder()
      .languageCode(languageCode.unwrap)
      .baseModelName(baseModelName.unwrap)
      .modelName(ModelName.unwrap(modelName): java.lang.String)
      .inputDataConfig(inputDataConfig.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.CreateLanguageModelRequest.ReadOnly =
    zio.aws.transcribe.model.CreateLanguageModelRequest.wrap(buildAwsValue())
}
object CreateLanguageModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.CreateLanguageModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.CreateLanguageModelRequest =
      zio.aws.transcribe.model.CreateLanguageModelRequest(
        languageCode,
        baseModelName,
        modelName,
        inputDataConfig.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def languageCode: zio.aws.transcribe.model.CLMLanguageCode
    def baseModelName: zio.aws.transcribe.model.BaseModelName
    def modelName: ModelName
    def inputDataConfig: zio.aws.transcribe.model.InputDataConfig.ReadOnly
    def tags: Option[List[zio.aws.transcribe.model.Tag.ReadOnly]]
    def getLanguageCode
        : ZIO[Any, Nothing, zio.aws.transcribe.model.CLMLanguageCode] =
      ZIO.succeed(languageCode)
    def getBaseModelName
        : ZIO[Any, Nothing, zio.aws.transcribe.model.BaseModelName] =
      ZIO.succeed(baseModelName)
    def getModelName: ZIO[Any, Nothing, ModelName] = ZIO.succeed(modelName)
    def getInputDataConfig
        : ZIO[Any, Nothing, zio.aws.transcribe.model.InputDataConfig.ReadOnly] =
      ZIO.succeed(inputDataConfig)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.transcribe.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.CreateLanguageModelRequest
  ) extends zio.aws.transcribe.model.CreateLanguageModelRequest.ReadOnly {
    override val languageCode: zio.aws.transcribe.model.CLMLanguageCode =
      zio.aws.transcribe.model.CLMLanguageCode.wrap(impl.languageCode())
    override val baseModelName: zio.aws.transcribe.model.BaseModelName =
      zio.aws.transcribe.model.BaseModelName.wrap(impl.baseModelName())
    override val modelName: ModelName =
      zio.aws.transcribe.model.primitives.ModelName(impl.modelName())
    override val inputDataConfig
        : zio.aws.transcribe.model.InputDataConfig.ReadOnly =
      zio.aws.transcribe.model.InputDataConfig.wrap(impl.inputDataConfig())
    override val tags: Option[List[zio.aws.transcribe.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transcribe.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.CreateLanguageModelRequest
  ): zio.aws.transcribe.model.CreateLanguageModelRequest.ReadOnly = new Wrapper(
    impl
  )
}
