package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.{DateTime, CategoryName}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class CategoryProperties(
    categoryName: Option[CategoryName] = None,
    rules: Option[Iterable[zio.aws.transcribe.model.Rule]] = None,
    createTime: Option[DateTime] = None,
    lastUpdateTime: Option[DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.CategoryProperties = {
    import CategoryProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.CategoryProperties
      .builder()
      .optionallyWith(
        categoryName.map(value => CategoryName.unwrap(value): java.lang.String)
      )(_.categoryName)
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .optionallyWith(createTime.map(value => DateTime.unwrap(value): Instant))(
        _.createTime
      )
      .optionallyWith(
        lastUpdateTime.map(value => DateTime.unwrap(value): Instant)
      )(_.lastUpdateTime)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.CategoryProperties.ReadOnly =
    zio.aws.transcribe.model.CategoryProperties.wrap(buildAwsValue())
}
object CategoryProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.CategoryProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.CategoryProperties =
      zio.aws.transcribe.model.CategoryProperties(
        categoryName.map(value => value),
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createTime.map(value => value),
        lastUpdateTime.map(value => value)
      )
    def categoryName: Option[CategoryName]
    def rules: Option[List[zio.aws.transcribe.model.Rule.ReadOnly]]
    def createTime: Option[DateTime]
    def lastUpdateTime: Option[DateTime]
    def getCategoryName: ZIO[Any, AwsError, CategoryName] =
      AwsError.unwrapOptionField("categoryName", categoryName)
    def getRules
        : ZIO[Any, AwsError, List[zio.aws.transcribe.model.Rule.ReadOnly]] =
      AwsError.unwrapOptionField("rules", rules)
    def getCreateTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getLastUpdateTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastUpdateTime", lastUpdateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.CategoryProperties
  ) extends zio.aws.transcribe.model.CategoryProperties.ReadOnly {
    override val categoryName: Option[CategoryName] = scala
      .Option(impl.categoryName())
      .map(value => zio.aws.transcribe.model.primitives.CategoryName(value))
    override val rules: Option[List[zio.aws.transcribe.model.Rule.ReadOnly]] =
      scala
        .Option(impl.rules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transcribe.model.Rule.wrap(item)
          }.toList
        )
    override val createTime: Option[DateTime] = scala
      .Option(impl.createTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val lastUpdateTime: Option[DateTime] = scala
      .Option(impl.lastUpdateTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.CategoryProperties
  ): zio.aws.transcribe.model.CategoryProperties.ReadOnly = new Wrapper(impl)
}
