package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.{DateTime, VocabularyName}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class VocabularyInfo(
    vocabularyName: Option[VocabularyName] = None,
    languageCode: Option[zio.aws.transcribe.model.LanguageCode] = None,
    lastModifiedTime: Option[DateTime] = None,
    vocabularyState: Option[zio.aws.transcribe.model.VocabularyState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.VocabularyInfo = {
    import VocabularyInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.VocabularyInfo
      .builder()
      .optionallyWith(
        vocabularyName.map(value =>
          VocabularyName.unwrap(value): java.lang.String
        )
      )(_.vocabularyName)
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(
        lastModifiedTime.map(value => DateTime.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(vocabularyState.map(value => value.unwrap))(
        _.vocabularyState
      )
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.VocabularyInfo.ReadOnly =
    zio.aws.transcribe.model.VocabularyInfo.wrap(buildAwsValue())
}
object VocabularyInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.VocabularyInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.VocabularyInfo =
      zio.aws.transcribe.model.VocabularyInfo(
        vocabularyName.map(value => value),
        languageCode.map(value => value),
        lastModifiedTime.map(value => value),
        vocabularyState.map(value => value)
      )
    def vocabularyName: Option[VocabularyName]
    def languageCode: Option[zio.aws.transcribe.model.LanguageCode]
    def lastModifiedTime: Option[DateTime]
    def vocabularyState: Option[zio.aws.transcribe.model.VocabularyState]
    def getVocabularyName: ZIO[Any, AwsError, VocabularyName] =
      AwsError.unwrapOptionField("vocabularyName", vocabularyName)
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.transcribe.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getLastModifiedTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getVocabularyState
        : ZIO[Any, AwsError, zio.aws.transcribe.model.VocabularyState] =
      AwsError.unwrapOptionField("vocabularyState", vocabularyState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.VocabularyInfo
  ) extends zio.aws.transcribe.model.VocabularyInfo.ReadOnly {
    override val vocabularyName: Option[VocabularyName] = scala
      .Option(impl.vocabularyName())
      .map(value => zio.aws.transcribe.model.primitives.VocabularyName(value))
    override val languageCode: Option[zio.aws.transcribe.model.LanguageCode] =
      scala
        .Option(impl.languageCode())
        .map(value => zio.aws.transcribe.model.LanguageCode.wrap(value))
    override val lastModifiedTime: Option[DateTime] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val vocabularyState
        : Option[zio.aws.transcribe.model.VocabularyState] = scala
      .Option(impl.vocabularyState())
      .map(value => zio.aws.transcribe.model.VocabularyState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.VocabularyInfo
  ): zio.aws.transcribe.model.VocabularyInfo.ReadOnly = new Wrapper(impl)
}
