package zio.aws.transcribe.model
import scala.jdk.CollectionConverters.*
sealed trait SentimentValue {
  def unwrap: software.amazon.awssdk.services.transcribe.model.SentimentValue
}
object SentimentValue {
  def wrap(
      value: software.amazon.awssdk.services.transcribe.model.SentimentValue
  ): zio.aws.transcribe.model.SentimentValue = value match {
    case software.amazon.awssdk.services.transcribe.model.SentimentValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transcribe.model.SentimentValue.POSITIVE =>
      val r = POSITIVE
      r
    case software.amazon.awssdk.services.transcribe.model.SentimentValue.NEGATIVE =>
      val r = NEGATIVE
      r
    case software.amazon.awssdk.services.transcribe.model.SentimentValue.NEUTRAL =>
      val r = NEUTRAL
      r
    case software.amazon.awssdk.services.transcribe.model.SentimentValue.MIXED =>
      val r = MIXED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transcribe.model.SentimentValue {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.SentimentValue =
      software.amazon.awssdk.services.transcribe.model.SentimentValue.UNKNOWN_TO_SDK_VERSION
  }
  case object POSITIVE extends zio.aws.transcribe.model.SentimentValue {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.SentimentValue =
      software.amazon.awssdk.services.transcribe.model.SentimentValue.POSITIVE
  }
  case object NEGATIVE extends zio.aws.transcribe.model.SentimentValue {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.SentimentValue =
      software.amazon.awssdk.services.transcribe.model.SentimentValue.NEGATIVE
  }
  case object NEUTRAL extends zio.aws.transcribe.model.SentimentValue {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.SentimentValue =
      software.amazon.awssdk.services.transcribe.model.SentimentValue.NEUTRAL
  }
  case object MIXED extends zio.aws.transcribe.model.SentimentValue {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.SentimentValue =
      software.amazon.awssdk.services.transcribe.model.SentimentValue.MIXED
  }
}
