package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateCallAnalyticsCategoryResponse(
    categoryProperties: Option[zio.aws.transcribe.model.CategoryProperties] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.UpdateCallAnalyticsCategoryResponse = {
    import UpdateCallAnalyticsCategoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.UpdateCallAnalyticsCategoryResponse
      .builder()
      .optionallyWith(categoryProperties.map(value => value.buildAwsValue()))(
        _.categoryProperties
      )
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.UpdateCallAnalyticsCategoryResponse.ReadOnly =
    zio.aws.transcribe.model.UpdateCallAnalyticsCategoryResponse
      .wrap(buildAwsValue())
}
object UpdateCallAnalyticsCategoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.UpdateCallAnalyticsCategoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.transcribe.model.UpdateCallAnalyticsCategoryResponse =
      zio.aws.transcribe.model.UpdateCallAnalyticsCategoryResponse(
        categoryProperties.map(value => value.asEditable)
      )
    def categoryProperties
        : Option[zio.aws.transcribe.model.CategoryProperties.ReadOnly]
    def getCategoryProperties: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.CategoryProperties.ReadOnly
    ] = AwsError.unwrapOptionField("categoryProperties", categoryProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.UpdateCallAnalyticsCategoryResponse
  ) extends zio.aws.transcribe.model.UpdateCallAnalyticsCategoryResponse.ReadOnly {
    override val categoryProperties
        : Option[zio.aws.transcribe.model.CategoryProperties.ReadOnly] = scala
      .Option(impl.categoryProperties())
      .map(value => zio.aws.transcribe.model.CategoryProperties.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.UpdateCallAnalyticsCategoryResponse
  ): zio.aws.transcribe.model.UpdateCallAnalyticsCategoryResponse.ReadOnly =
    new Wrapper(impl)
}
