package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Subtitles(
    formats: Option[Iterable[zio.aws.transcribe.model.SubtitleFormat]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.Subtitles = {
    import Subtitles.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.Subtitles
      .builder()
      .optionallyWith(
        formats.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.formatsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.Subtitles.ReadOnly =
    zio.aws.transcribe.model.Subtitles.wrap(buildAwsValue())
}
object Subtitles {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.Subtitles
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.Subtitles =
      zio.aws.transcribe.model.Subtitles(formats.map(value => value))
    def formats: Option[List[zio.aws.transcribe.model.SubtitleFormat]]
    def getFormats
        : ZIO[Any, AwsError, List[zio.aws.transcribe.model.SubtitleFormat]] =
      AwsError.unwrapOptionField("formats", formats)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.Subtitles
  ) extends zio.aws.transcribe.model.Subtitles.ReadOnly {
    override val formats
        : Option[List[zio.aws.transcribe.model.SubtitleFormat]] = scala
      .Option(impl.formats())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transcribe.model.SubtitleFormat.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.Subtitles
  ): zio.aws.transcribe.model.Subtitles.ReadOnly = new Wrapper(impl)
}
