package zio.aws.transcribe.model
import java.lang.Integer
import zio.ZIO
import zio.aws.transcribe.model.primitives.{
  OutputBucketName,
  MediaSampleRateHertz,
  OutputKey,
  NonEmptyString,
  TranscriptionJobName,
  KMSKeyId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StartTranscriptionJobRequest(
    transcriptionJobName: TranscriptionJobName,
    languageCode: Option[zio.aws.transcribe.model.LanguageCode] = None,
    mediaSampleRateHertz: Option[MediaSampleRateHertz] = None,
    mediaFormat: Option[zio.aws.transcribe.model.MediaFormat] = None,
    media: zio.aws.transcribe.model.Media,
    outputBucketName: Option[OutputBucketName] = None,
    outputKey: Option[OutputKey] = None,
    outputEncryptionKMSKeyId: Option[KMSKeyId] = None,
    kmsEncryptionContext: Option[Map[NonEmptyString, NonEmptyString]] = None,
    settings: Option[zio.aws.transcribe.model.Settings] = None,
    modelSettings: Option[zio.aws.transcribe.model.ModelSettings] = None,
    jobExecutionSettings: Option[
      zio.aws.transcribe.model.JobExecutionSettings
    ] = None,
    contentRedaction: Option[zio.aws.transcribe.model.ContentRedaction] = None,
    identifyLanguage: Option[Boolean] = None,
    languageOptions: Option[Iterable[zio.aws.transcribe.model.LanguageCode]] =
      None,
    subtitles: Option[zio.aws.transcribe.model.Subtitles] = None,
    tags: Option[Iterable[zio.aws.transcribe.model.Tag]] = None,
    languageIdSettings: Option[Map[
      zio.aws.transcribe.model.LanguageCode,
      zio.aws.transcribe.model.LanguageIdSettings
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.StartTranscriptionJobRequest = {
    import StartTranscriptionJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.StartTranscriptionJobRequest
      .builder()
      .transcriptionJobName(
        TranscriptionJobName.unwrap(transcriptionJobName): java.lang.String
      )
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(
        mediaSampleRateHertz.map(value =>
          MediaSampleRateHertz.unwrap(value): Integer
        )
      )(_.mediaSampleRateHertz)
      .optionallyWith(mediaFormat.map(value => value.unwrap))(_.mediaFormat)
      .media(media.buildAwsValue())
      .optionallyWith(
        outputBucketName.map(value =>
          OutputBucketName.unwrap(value): java.lang.String
        )
      )(_.outputBucketName)
      .optionallyWith(
        outputKey.map(value => OutputKey.unwrap(value): java.lang.String)
      )(_.outputKey)
      .optionallyWith(
        outputEncryptionKMSKeyId.map(value =>
          KMSKeyId.unwrap(value): java.lang.String
        )
      )(_.outputEncryptionKMSKeyId)
      .optionallyWith(
        kmsEncryptionContext.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.kmsEncryptionContext)
      .optionallyWith(settings.map(value => value.buildAwsValue()))(_.settings)
      .optionallyWith(modelSettings.map(value => value.buildAwsValue()))(
        _.modelSettings
      )
      .optionallyWith(jobExecutionSettings.map(value => value.buildAwsValue()))(
        _.jobExecutionSettings
      )
      .optionallyWith(contentRedaction.map(value => value.buildAwsValue()))(
        _.contentRedaction
      )
      .optionallyWith(identifyLanguage.map(value => value: java.lang.Boolean))(
        _.identifyLanguage
      )
      .optionallyWith(
        languageOptions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.languageOptionsWithStrings)
      .optionallyWith(subtitles.map(value => value.buildAwsValue()))(
        _.subtitles
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        languageIdSettings.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.languageIdSettingsWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.StartTranscriptionJobRequest.ReadOnly =
    zio.aws.transcribe.model.StartTranscriptionJobRequest.wrap(buildAwsValue())
}
object StartTranscriptionJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.StartTranscriptionJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.StartTranscriptionJobRequest =
      zio.aws.transcribe.model.StartTranscriptionJobRequest(
        transcriptionJobName,
        languageCode.map(value => value),
        mediaSampleRateHertz.map(value => value),
        mediaFormat.map(value => value),
        media.asEditable,
        outputBucketName.map(value => value),
        outputKey.map(value => value),
        outputEncryptionKMSKeyId.map(value => value),
        kmsEncryptionContext.map(value => value),
        settings.map(value => value.asEditable),
        modelSettings.map(value => value.asEditable),
        jobExecutionSettings.map(value => value.asEditable),
        contentRedaction.map(value => value.asEditable),
        identifyLanguage.map(value => value),
        languageOptions.map(value => value),
        subtitles.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        languageIdSettings.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def transcriptionJobName: TranscriptionJobName
    def languageCode: Option[zio.aws.transcribe.model.LanguageCode]
    def mediaSampleRateHertz: Option[MediaSampleRateHertz]
    def mediaFormat: Option[zio.aws.transcribe.model.MediaFormat]
    def media: zio.aws.transcribe.model.Media.ReadOnly
    def outputBucketName: Option[OutputBucketName]
    def outputKey: Option[OutputKey]
    def outputEncryptionKMSKeyId: Option[KMSKeyId]
    def kmsEncryptionContext: Option[Map[NonEmptyString, NonEmptyString]]
    def settings: Option[zio.aws.transcribe.model.Settings.ReadOnly]
    def modelSettings: Option[zio.aws.transcribe.model.ModelSettings.ReadOnly]
    def jobExecutionSettings
        : Option[zio.aws.transcribe.model.JobExecutionSettings.ReadOnly]
    def contentRedaction
        : Option[zio.aws.transcribe.model.ContentRedaction.ReadOnly]
    def identifyLanguage: Option[Boolean]
    def languageOptions: Option[List[zio.aws.transcribe.model.LanguageCode]]
    def subtitles: Option[zio.aws.transcribe.model.Subtitles.ReadOnly]
    def tags: Option[List[zio.aws.transcribe.model.Tag.ReadOnly]]
    def languageIdSettings: Option[Map[
      zio.aws.transcribe.model.LanguageCode,
      zio.aws.transcribe.model.LanguageIdSettings.ReadOnly
    ]]
    def getTranscriptionJobName: ZIO[Any, Nothing, TranscriptionJobName] =
      ZIO.succeed(transcriptionJobName)
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.transcribe.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getMediaSampleRateHertz: ZIO[Any, AwsError, MediaSampleRateHertz] =
      AwsError.unwrapOptionField("mediaSampleRateHertz", mediaSampleRateHertz)
    def getMediaFormat
        : ZIO[Any, AwsError, zio.aws.transcribe.model.MediaFormat] =
      AwsError.unwrapOptionField("mediaFormat", mediaFormat)
    def getMedia: ZIO[Any, Nothing, zio.aws.transcribe.model.Media.ReadOnly] =
      ZIO.succeed(media)
    def getOutputBucketName: ZIO[Any, AwsError, OutputBucketName] =
      AwsError.unwrapOptionField("outputBucketName", outputBucketName)
    def getOutputKey: ZIO[Any, AwsError, OutputKey] =
      AwsError.unwrapOptionField("outputKey", outputKey)
    def getOutputEncryptionKMSKeyId: ZIO[Any, AwsError, KMSKeyId] = AwsError
      .unwrapOptionField("outputEncryptionKMSKeyId", outputEncryptionKMSKeyId)
    def getKmsEncryptionContext
        : ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("kmsEncryptionContext", kmsEncryptionContext)
    def getSettings
        : ZIO[Any, AwsError, zio.aws.transcribe.model.Settings.ReadOnly] =
      AwsError.unwrapOptionField("settings", settings)
    def getModelSettings
        : ZIO[Any, AwsError, zio.aws.transcribe.model.ModelSettings.ReadOnly] =
      AwsError.unwrapOptionField("modelSettings", modelSettings)
    def getJobExecutionSettings: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.JobExecutionSettings.ReadOnly
    ] = AwsError.unwrapOptionField("jobExecutionSettings", jobExecutionSettings)
    def getContentRedaction: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.ContentRedaction.ReadOnly
    ] = AwsError.unwrapOptionField("contentRedaction", contentRedaction)
    def getIdentifyLanguage: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("identifyLanguage", identifyLanguage)
    def getLanguageOptions
        : ZIO[Any, AwsError, List[zio.aws.transcribe.model.LanguageCode]] =
      AwsError.unwrapOptionField("languageOptions", languageOptions)
    def getSubtitles
        : ZIO[Any, AwsError, zio.aws.transcribe.model.Subtitles.ReadOnly] =
      AwsError.unwrapOptionField("subtitles", subtitles)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.transcribe.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getLanguageIdSettings: ZIO[Any, AwsError, Map[
      zio.aws.transcribe.model.LanguageCode,
      zio.aws.transcribe.model.LanguageIdSettings.ReadOnly
    ]] = AwsError.unwrapOptionField("languageIdSettings", languageIdSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.StartTranscriptionJobRequest
  ) extends zio.aws.transcribe.model.StartTranscriptionJobRequest.ReadOnly {
    override val transcriptionJobName: TranscriptionJobName =
      zio.aws.transcribe.model.primitives
        .TranscriptionJobName(impl.transcriptionJobName())
    override val languageCode: Option[zio.aws.transcribe.model.LanguageCode] =
      scala
        .Option(impl.languageCode())
        .map(value => zio.aws.transcribe.model.LanguageCode.wrap(value))
    override val mediaSampleRateHertz: Option[MediaSampleRateHertz] = scala
      .Option(impl.mediaSampleRateHertz())
      .map(value =>
        zio.aws.transcribe.model.primitives.MediaSampleRateHertz(value)
      )
    override val mediaFormat: Option[zio.aws.transcribe.model.MediaFormat] =
      scala
        .Option(impl.mediaFormat())
        .map(value => zio.aws.transcribe.model.MediaFormat.wrap(value))
    override val media: zio.aws.transcribe.model.Media.ReadOnly =
      zio.aws.transcribe.model.Media.wrap(impl.media())
    override val outputBucketName: Option[OutputBucketName] = scala
      .Option(impl.outputBucketName())
      .map(value => zio.aws.transcribe.model.primitives.OutputBucketName(value))
    override val outputKey: Option[OutputKey] = scala
      .Option(impl.outputKey())
      .map(value => zio.aws.transcribe.model.primitives.OutputKey(value))
    override val outputEncryptionKMSKeyId: Option[KMSKeyId] = scala
      .Option(impl.outputEncryptionKMSKeyId())
      .map(value => zio.aws.transcribe.model.primitives.KMSKeyId(value))
    override val kmsEncryptionContext
        : Option[Map[NonEmptyString, NonEmptyString]] = scala
      .Option(impl.kmsEncryptionContext())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.transcribe.model.primitives.NonEmptyString(
              key
            ) -> zio.aws.transcribe.model.primitives.NonEmptyString(value)
          })
          .toMap
      )
    override val settings: Option[zio.aws.transcribe.model.Settings.ReadOnly] =
      scala
        .Option(impl.settings())
        .map(value => zio.aws.transcribe.model.Settings.wrap(value))
    override val modelSettings
        : Option[zio.aws.transcribe.model.ModelSettings.ReadOnly] = scala
      .Option(impl.modelSettings())
      .map(value => zio.aws.transcribe.model.ModelSettings.wrap(value))
    override val jobExecutionSettings
        : Option[zio.aws.transcribe.model.JobExecutionSettings.ReadOnly] = scala
      .Option(impl.jobExecutionSettings())
      .map(value => zio.aws.transcribe.model.JobExecutionSettings.wrap(value))
    override val contentRedaction
        : Option[zio.aws.transcribe.model.ContentRedaction.ReadOnly] = scala
      .Option(impl.contentRedaction())
      .map(value => zio.aws.transcribe.model.ContentRedaction.wrap(value))
    override val identifyLanguage: Option[Boolean] =
      scala.Option(impl.identifyLanguage()).map(value => value: Boolean)
    override val languageOptions
        : Option[List[zio.aws.transcribe.model.LanguageCode]] = scala
      .Option(impl.languageOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transcribe.model.LanguageCode.wrap(item)
        }.toList
      )
    override val subtitles
        : Option[zio.aws.transcribe.model.Subtitles.ReadOnly] = scala
      .Option(impl.subtitles())
      .map(value => zio.aws.transcribe.model.Subtitles.wrap(value))
    override val tags: Option[List[zio.aws.transcribe.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transcribe.model.Tag.wrap(item)
          }.toList
        )
    override val languageIdSettings: Option[Map[
      zio.aws.transcribe.model.LanguageCode,
      zio.aws.transcribe.model.LanguageIdSettings.ReadOnly
    ]] = scala
      .Option(impl.languageIdSettings())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.transcribe.model.LanguageCode.wrap(
              key
            ) -> zio.aws.transcribe.model.LanguageIdSettings.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.StartTranscriptionJobRequest
  ): zio.aws.transcribe.model.StartTranscriptionJobRequest.ReadOnly =
    new Wrapper(impl)
}
