package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.Uri
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Media(
    mediaFileUri: Option[Uri] = None,
    redactedMediaFileUri: Option[Uri] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.Media = {
    import Media.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.Media
      .builder()
      .optionallyWith(
        mediaFileUri.map(value => Uri.unwrap(value): java.lang.String)
      )(_.mediaFileUri)
      .optionallyWith(
        redactedMediaFileUri.map(value => Uri.unwrap(value): java.lang.String)
      )(_.redactedMediaFileUri)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.Media.ReadOnly =
    zio.aws.transcribe.model.Media.wrap(buildAwsValue())
}
object Media {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.transcribe.model.Media] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.Media =
      zio.aws.transcribe.model.Media(
        mediaFileUri.map(value => value),
        redactedMediaFileUri.map(value => value)
      )
    def mediaFileUri: Option[Uri]
    def redactedMediaFileUri: Option[Uri]
    def getMediaFileUri: ZIO[Any, AwsError, Uri] =
      AwsError.unwrapOptionField("mediaFileUri", mediaFileUri)
    def getRedactedMediaFileUri: ZIO[Any, AwsError, Uri] =
      AwsError.unwrapOptionField("redactedMediaFileUri", redactedMediaFileUri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.Media
  ) extends zio.aws.transcribe.model.Media.ReadOnly {
    override val mediaFileUri: Option[Uri] = scala
      .Option(impl.mediaFileUri())
      .map(value => zio.aws.transcribe.model.primitives.Uri(value))
    override val redactedMediaFileUri: Option[Uri] = scala
      .Option(impl.redactedMediaFileUri())
      .map(value => zio.aws.transcribe.model.primitives.Uri(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.Media
  ): zio.aws.transcribe.model.Media.ReadOnly = new Wrapper(impl)
}
