package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListMedicalVocabulariesResponse(
    status: Option[zio.aws.transcribe.model.VocabularyState] = None,
    nextToken: Option[NextToken] = None,
    vocabularies: Option[Iterable[zio.aws.transcribe.model.VocabularyInfo]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesResponse = {
    import ListMedicalVocabulariesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesResponse
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        vocabularies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vocabularies)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.ListMedicalVocabulariesResponse.ReadOnly =
    zio.aws.transcribe.model.ListMedicalVocabulariesResponse
      .wrap(buildAwsValue())
}
object ListMedicalVocabulariesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.ListMedicalVocabulariesResponse =
      zio.aws.transcribe.model.ListMedicalVocabulariesResponse(
        status.map(value => value),
        nextToken.map(value => value),
        vocabularies.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def status: Option[zio.aws.transcribe.model.VocabularyState]
    def nextToken: Option[NextToken]
    def vocabularies
        : Option[List[zio.aws.transcribe.model.VocabularyInfo.ReadOnly]]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.transcribe.model.VocabularyState] =
      AwsError.unwrapOptionField("status", status)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getVocabularies: ZIO[Any, AwsError, List[
      zio.aws.transcribe.model.VocabularyInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("vocabularies", vocabularies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesResponse
  ) extends zio.aws.transcribe.model.ListMedicalVocabulariesResponse.ReadOnly {
    override val status: Option[zio.aws.transcribe.model.VocabularyState] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.transcribe.model.VocabularyState.wrap(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.transcribe.model.primitives.NextToken(value))
    override val vocabularies
        : Option[List[zio.aws.transcribe.model.VocabularyInfo.ReadOnly]] = scala
      .Option(impl.vocabularies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transcribe.model.VocabularyInfo.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.ListMedicalVocabulariesResponse
  ): zio.aws.transcribe.model.ListMedicalVocabulariesResponse.ReadOnly =
    new Wrapper(impl)
}
