package zio.aws.transcribe
import zio.aws.transcribe.model.MedicalTranscriptionJobSummary.ReadOnly
import software.amazon.awssdk.services.transcribe.{
  TranscribeAsyncClientBuilder,
  TranscribeAsyncClient
}
import software.amazon.awssdk.services.transcribe.model.{
  GetMedicalTranscriptionJobRequest,
  DeleteMedicalVocabularyRequest,
  GetVocabularyFilterResponse,
  DeleteLanguageModelRequest,
  DeleteVocabularyResponse,
  ListTranscriptionJobsRequest,
  CreateCallAnalyticsCategoryRequest,
  UpdateCallAnalyticsCategoryResponse,
  CreateVocabularyFilterRequest,
  ListMedicalTranscriptionJobsResponse,
  CreateVocabularyResponse,
  GetMedicalVocabularyRequest,
  DeleteTranscriptionJobRequest,
  UpdateMedicalVocabularyResponse,
  ListTranscriptionJobsResponse,
  GetTranscriptionJobResponse,
  CreateVocabularyRequest,
  VocabularyFilterInfo,
  CreateMedicalVocabularyRequest,
  DeleteCallAnalyticsJobRequest,
  DeleteCallAnalyticsCategoryRequest,
  ListCallAnalyticsCategoriesRequest,
  DeleteMedicalTranscriptionJobRequest,
  UpdateVocabularyFilterResponse,
  ListVocabularyFiltersResponse,
  CategoryProperties,
  GetVocabularyResponse,
  ListMedicalTranscriptionJobsRequest,
  ListCallAnalyticsJobsRequest,
  StartTranscriptionJobResponse,
  DeleteMedicalTranscriptionJobResponse,
  ListTagsForResourceRequest,
  GetCallAnalyticsJobResponse,
  DescribeLanguageModelRequest,
  ListVocabularyFiltersRequest,
  TranscriptionJobSummary,
  MedicalTranscriptionJobSummary,
  UpdateVocabularyRequest,
  DescribeLanguageModelResponse,
  DeleteVocabularyFilterRequest,
  StartCallAnalyticsJobResponse,
  CallAnalyticsJobSummary,
  UpdateVocabularyResponse,
  DeleteTranscriptionJobResponse,
  DeleteCallAnalyticsJobResponse,
  ListTagsForResourceResponse,
  CreateMedicalVocabularyResponse,
  UntagResourceResponse,
  ListCallAnalyticsJobsResponse,
  StartMedicalTranscriptionJobRequest,
  GetCallAnalyticsCategoryResponse,
  UpdateVocabularyFilterRequest,
  GetCallAnalyticsJobRequest,
  StartTranscriptionJobRequest,
  ListMedicalVocabulariesResponse,
  GetVocabularyFilterRequest,
  ListCallAnalyticsCategoriesResponse,
  VocabularyInfo,
  CreateLanguageModelResponse,
  ListMedicalVocabulariesRequest,
  DeleteLanguageModelResponse,
  StartMedicalTranscriptionJobResponse,
  ListVocabulariesResponse,
  GetCallAnalyticsCategoryRequest,
  UntagResourceRequest,
  CreateCallAnalyticsCategoryResponse,
  DeleteMedicalVocabularyResponse,
  DeleteVocabularyRequest,
  GetMedicalTranscriptionJobResponse,
  GetMedicalVocabularyResponse,
  ListLanguageModelsResponse,
  StartCallAnalyticsJobRequest,
  UpdateCallAnalyticsCategoryRequest,
  TagResourceResponse,
  GetVocabularyRequest,
  CreateLanguageModelRequest,
  ListVocabulariesRequest,
  DeleteCallAnalyticsCategoryResponse,
  TagResourceRequest,
  DeleteVocabularyFilterResponse,
  UpdateMedicalVocabularyRequest,
  GetTranscriptionJobRequest,
  ListLanguageModelsRequest,
  CreateVocabularyFilterResponse,
  LanguageModel
}
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait Transcribe extends AspectSupport[Transcribe] {
  val api: TranscribeAsyncClient
  def listVocabularyFilters(
      request: zio.aws.transcribe.model.ListVocabularyFiltersRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.transcribe.model.VocabularyFilterInfo.ReadOnly
  ]
  def listVocabularyFiltersPaginated(
      request: zio.aws.transcribe.model.ListVocabularyFiltersRequest
  ): IO[
    AwsError,
    zio.aws.transcribe.model.ListVocabularyFiltersResponse.ReadOnly
  ]
  def getCallAnalyticsJob(
      request: zio.aws.transcribe.model.GetCallAnalyticsJobRequest
  ): IO[AwsError, zio.aws.transcribe.model.GetCallAnalyticsJobResponse.ReadOnly]
  def deleteMedicalVocabulary(
      request: zio.aws.transcribe.model.DeleteMedicalVocabularyRequest
  ): IO[AwsError, Unit]
  def deleteVocabulary(
      request: zio.aws.transcribe.model.DeleteVocabularyRequest
  ): IO[AwsError, Unit]
  def updateCallAnalyticsCategory(
      request: zio.aws.transcribe.model.UpdateCallAnalyticsCategoryRequest
  ): IO[
    AwsError,
    zio.aws.transcribe.model.UpdateCallAnalyticsCategoryResponse.ReadOnly
  ]
  def listMedicalTranscriptionJobs(
      request: zio.aws.transcribe.model.ListMedicalTranscriptionJobsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.transcribe.model.ListMedicalTranscriptionJobsResponse.ReadOnly,
    ReadOnly
  ]]
  def listMedicalTranscriptionJobsPaginated(
      request: zio.aws.transcribe.model.ListMedicalTranscriptionJobsRequest
  ): IO[
    AwsError,
    zio.aws.transcribe.model.ListMedicalTranscriptionJobsResponse.ReadOnly
  ]
  def updateVocabularyFilter(
      request: zio.aws.transcribe.model.UpdateVocabularyFilterRequest
  ): IO[
    AwsError,
    zio.aws.transcribe.model.UpdateVocabularyFilterResponse.ReadOnly
  ]
  def createLanguageModel(
      request: zio.aws.transcribe.model.CreateLanguageModelRequest
  ): IO[AwsError, zio.aws.transcribe.model.CreateLanguageModelResponse.ReadOnly]
  def deleteCallAnalyticsCategory(
      request: zio.aws.transcribe.model.DeleteCallAnalyticsCategoryRequest
  ): IO[
    AwsError,
    zio.aws.transcribe.model.DeleteCallAnalyticsCategoryResponse.ReadOnly
  ]
  def getMedicalTranscriptionJob(
      request: zio.aws.transcribe.model.GetMedicalTranscriptionJobRequest
  ): IO[
    AwsError,
    zio.aws.transcribe.model.GetMedicalTranscriptionJobResponse.ReadOnly
  ]
  def updateMedicalVocabulary(
      request: zio.aws.transcribe.model.UpdateMedicalVocabularyRequest
  ): IO[
    AwsError,
    zio.aws.transcribe.model.UpdateMedicalVocabularyResponse.ReadOnly
  ]
  def createVocabulary(
      request: zio.aws.transcribe.model.CreateVocabularyRequest
  ): IO[AwsError, zio.aws.transcribe.model.CreateVocabularyResponse.ReadOnly]
  def createMedicalVocabulary(
      request: zio.aws.transcribe.model.CreateMedicalVocabularyRequest
  ): IO[
    AwsError,
    zio.aws.transcribe.model.CreateMedicalVocabularyResponse.ReadOnly
  ]
  def getCallAnalyticsCategory(
      request: zio.aws.transcribe.model.GetCallAnalyticsCategoryRequest
  ): IO[
    AwsError,
    zio.aws.transcribe.model.GetCallAnalyticsCategoryResponse.ReadOnly
  ]
  def listMedicalVocabularies(
      request: zio.aws.transcribe.model.ListMedicalVocabulariesRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.transcribe.model.ListMedicalVocabulariesResponse.ReadOnly,
    zio.aws.transcribe.model.VocabularyInfo.ReadOnly
  ]]
  def listMedicalVocabulariesPaginated(
      request: zio.aws.transcribe.model.ListMedicalVocabulariesRequest
  ): IO[
    AwsError,
    zio.aws.transcribe.model.ListMedicalVocabulariesResponse.ReadOnly
  ]
  def deleteCallAnalyticsJob(
      request: zio.aws.transcribe.model.DeleteCallAnalyticsJobRequest
  ): IO[
    AwsError,
    zio.aws.transcribe.model.DeleteCallAnalyticsJobResponse.ReadOnly
  ]
  def getVocabularyFilter(
      request: zio.aws.transcribe.model.GetVocabularyFilterRequest
  ): IO[AwsError, zio.aws.transcribe.model.GetVocabularyFilterResponse.ReadOnly]
  def updateVocabulary(
      request: zio.aws.transcribe.model.UpdateVocabularyRequest
  ): IO[AwsError, zio.aws.transcribe.model.UpdateVocabularyResponse.ReadOnly]
  def listVocabularies(
      request: zio.aws.transcribe.model.ListVocabulariesRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.transcribe.model.ListVocabulariesResponse.ReadOnly,
    zio.aws.transcribe.model.VocabularyInfo.ReadOnly
  ]]
  def listVocabulariesPaginated(
      request: zio.aws.transcribe.model.ListVocabulariesRequest
  ): IO[AwsError, zio.aws.transcribe.model.ListVocabulariesResponse.ReadOnly]
  def startCallAnalyticsJob(
      request: zio.aws.transcribe.model.StartCallAnalyticsJobRequest
  ): IO[
    AwsError,
    zio.aws.transcribe.model.StartCallAnalyticsJobResponse.ReadOnly
  ]
  def untagResource(
      request: zio.aws.transcribe.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.transcribe.model.UntagResourceResponse.ReadOnly]
  def createVocabularyFilter(
      request: zio.aws.transcribe.model.CreateVocabularyFilterRequest
  ): IO[
    AwsError,
    zio.aws.transcribe.model.CreateVocabularyFilterResponse.ReadOnly
  ]
  def deleteTranscriptionJob(
      request: zio.aws.transcribe.model.DeleteTranscriptionJobRequest
  ): IO[AwsError, Unit]
  def listTranscriptionJobs(
      request: zio.aws.transcribe.model.ListTranscriptionJobsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.transcribe.model.ListTranscriptionJobsResponse.ReadOnly,
    zio.aws.transcribe.model.TranscriptionJobSummary.ReadOnly
  ]]
  def listTranscriptionJobsPaginated(
      request: zio.aws.transcribe.model.ListTranscriptionJobsRequest
  ): IO[
    AwsError,
    zio.aws.transcribe.model.ListTranscriptionJobsResponse.ReadOnly
  ]
  def describeLanguageModel(
      request: zio.aws.transcribe.model.DescribeLanguageModelRequest
  ): IO[
    AwsError,
    zio.aws.transcribe.model.DescribeLanguageModelResponse.ReadOnly
  ]
  def listTagsForResource(
      request: zio.aws.transcribe.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.transcribe.model.ListTagsForResourceResponse.ReadOnly]
  def deleteLanguageModel(
      request: zio.aws.transcribe.model.DeleteLanguageModelRequest
  ): IO[AwsError, Unit]
  def tagResource(
      request: zio.aws.transcribe.model.TagResourceRequest
  ): IO[AwsError, zio.aws.transcribe.model.TagResourceResponse.ReadOnly]
  def startMedicalTranscriptionJob(
      request: zio.aws.transcribe.model.StartMedicalTranscriptionJobRequest
  ): IO[
    AwsError,
    zio.aws.transcribe.model.StartMedicalTranscriptionJobResponse.ReadOnly
  ]
  def listLanguageModels(
      request: zio.aws.transcribe.model.ListLanguageModelsRequest
  ): ZStream[Any, AwsError, zio.aws.transcribe.model.LanguageModel.ReadOnly]
  def listLanguageModelsPaginated(
      request: zio.aws.transcribe.model.ListLanguageModelsRequest
  ): IO[AwsError, zio.aws.transcribe.model.ListLanguageModelsResponse.ReadOnly]
  def createCallAnalyticsCategory(
      request: zio.aws.transcribe.model.CreateCallAnalyticsCategoryRequest
  ): IO[
    AwsError,
    zio.aws.transcribe.model.CreateCallAnalyticsCategoryResponse.ReadOnly
  ]
  def getVocabulary(
      request: zio.aws.transcribe.model.GetVocabularyRequest
  ): IO[AwsError, zio.aws.transcribe.model.GetVocabularyResponse.ReadOnly]
  def getMedicalVocabulary(
      request: zio.aws.transcribe.model.GetMedicalVocabularyRequest
  ): IO[
    AwsError,
    zio.aws.transcribe.model.GetMedicalVocabularyResponse.ReadOnly
  ]
  def startTranscriptionJob(
      request: zio.aws.transcribe.model.StartTranscriptionJobRequest
  ): IO[
    AwsError,
    zio.aws.transcribe.model.StartTranscriptionJobResponse.ReadOnly
  ]
  def deleteVocabularyFilter(
      request: zio.aws.transcribe.model.DeleteVocabularyFilterRequest
  ): IO[AwsError, Unit]
  def deleteMedicalTranscriptionJob(
      request: zio.aws.transcribe.model.DeleteMedicalTranscriptionJobRequest
  ): IO[AwsError, Unit]
  def listCallAnalyticsCategories(
      request: zio.aws.transcribe.model.ListCallAnalyticsCategoriesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.transcribe.model.CategoryProperties.ReadOnly
  ]
  def listCallAnalyticsCategoriesPaginated(
      request: zio.aws.transcribe.model.ListCallAnalyticsCategoriesRequest
  ): IO[
    AwsError,
    zio.aws.transcribe.model.ListCallAnalyticsCategoriesResponse.ReadOnly
  ]
  def getTranscriptionJob(
      request: zio.aws.transcribe.model.GetTranscriptionJobRequest
  ): IO[AwsError, zio.aws.transcribe.model.GetTranscriptionJobResponse.ReadOnly]
  def listCallAnalyticsJobs(
      request: zio.aws.transcribe.model.ListCallAnalyticsJobsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.transcribe.model.ListCallAnalyticsJobsResponse.ReadOnly,
    zio.aws.transcribe.model.CallAnalyticsJobSummary.ReadOnly
  ]]
  def listCallAnalyticsJobsPaginated(
      request: zio.aws.transcribe.model.ListCallAnalyticsJobsRequest
  ): IO[
    AwsError,
    zio.aws.transcribe.model.ListCallAnalyticsJobsResponse.ReadOnly
  ]
}
object Transcribe {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Transcribe] = customized(
    identity
  )
  def customized(
      customization: TranscribeAsyncClientBuilder => TranscribeAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Transcribe] = managed(
    customization
  ).toLayer
  def managed(
      customization: TranscribeAsyncClientBuilder => TranscribeAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Transcribe] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = TranscribeAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[TranscribeAsyncClient, TranscribeAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[TranscribeAsyncClient, TranscribeAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new TranscribeImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class TranscribeImpl[R](
      override val api: TranscribeAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Transcribe
      with AwsServiceBase[R] {
    override val serviceName: String = "Transcribe"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): TranscribeImpl[R1] = new TranscribeImpl(api, newAspect, r)
    def listVocabularyFilters(
        request: zio.aws.transcribe.model.ListVocabularyFiltersRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.transcribe.model.VocabularyFilterInfo.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListVocabularyFiltersRequest,
      ListVocabularyFiltersResponse,
      VocabularyFilterInfo
    ](
      "listVocabularyFilters",
      api.listVocabularyFilters,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.vocabularyFilters().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.transcribe.model.VocabularyFilterInfo.wrap(item))
      .provideEnvironment(r)
    def listVocabularyFiltersPaginated(
        request: zio.aws.transcribe.model.ListVocabularyFiltersRequest
    ): IO[
      AwsError,
      zio.aws.transcribe.model.ListVocabularyFiltersResponse.ReadOnly
    ] = asyncRequestResponse[
      ListVocabularyFiltersRequest,
      ListVocabularyFiltersResponse
    ]("listVocabularyFilters", api.listVocabularyFilters)(
      request.buildAwsValue()
    ).map(zio.aws.transcribe.model.ListVocabularyFiltersResponse.wrap)
      .provideEnvironment(r)
    def getCallAnalyticsJob(
        request: zio.aws.transcribe.model.GetCallAnalyticsJobRequest
    ): IO[
      AwsError,
      zio.aws.transcribe.model.GetCallAnalyticsJobResponse.ReadOnly
    ] = asyncRequestResponse[
      GetCallAnalyticsJobRequest,
      GetCallAnalyticsJobResponse
    ]("getCallAnalyticsJob", api.getCallAnalyticsJob)(request.buildAwsValue())
      .map(zio.aws.transcribe.model.GetCallAnalyticsJobResponse.wrap)
      .provideEnvironment(r)
    def deleteMedicalVocabulary(
        request: zio.aws.transcribe.model.DeleteMedicalVocabularyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteMedicalVocabularyRequest,
      DeleteMedicalVocabularyResponse
    ]("deleteMedicalVocabulary", api.deleteMedicalVocabulary)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteVocabulary(
        request: zio.aws.transcribe.model.DeleteVocabularyRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteVocabularyRequest, DeleteVocabularyResponse](
        "deleteVocabulary",
        api.deleteVocabulary
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def updateCallAnalyticsCategory(
        request: zio.aws.transcribe.model.UpdateCallAnalyticsCategoryRequest
    ): IO[
      AwsError,
      zio.aws.transcribe.model.UpdateCallAnalyticsCategoryResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateCallAnalyticsCategoryRequest,
      UpdateCallAnalyticsCategoryResponse
    ]("updateCallAnalyticsCategory", api.updateCallAnalyticsCategory)(
      request.buildAwsValue()
    ).map(zio.aws.transcribe.model.UpdateCallAnalyticsCategoryResponse.wrap)
      .provideEnvironment(r)
    def listMedicalTranscriptionJobs(
        request: zio.aws.transcribe.model.ListMedicalTranscriptionJobsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.transcribe.model.ListMedicalTranscriptionJobsResponse.ReadOnly,
      ReadOnly
    ]] = asyncPaginatedRequest[
      ListMedicalTranscriptionJobsRequest,
      ListMedicalTranscriptionJobsResponse,
      MedicalTranscriptionJobSummary
    ](
      "listMedicalTranscriptionJobs",
      api.listMedicalTranscriptionJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.medicalTranscriptionJobSummaries().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.transcribe.model.ListMedicalTranscriptionJobsResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.transcribe.model.MedicalTranscriptionJobSummary.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listMedicalTranscriptionJobsPaginated(
        request: zio.aws.transcribe.model.ListMedicalTranscriptionJobsRequest
    ): IO[
      AwsError,
      zio.aws.transcribe.model.ListMedicalTranscriptionJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListMedicalTranscriptionJobsRequest,
      ListMedicalTranscriptionJobsResponse
    ]("listMedicalTranscriptionJobs", api.listMedicalTranscriptionJobs)(
      request.buildAwsValue()
    ).map(zio.aws.transcribe.model.ListMedicalTranscriptionJobsResponse.wrap)
      .provideEnvironment(r)
    def updateVocabularyFilter(
        request: zio.aws.transcribe.model.UpdateVocabularyFilterRequest
    ): IO[
      AwsError,
      zio.aws.transcribe.model.UpdateVocabularyFilterResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateVocabularyFilterRequest,
      UpdateVocabularyFilterResponse
    ]("updateVocabularyFilter", api.updateVocabularyFilter)(
      request.buildAwsValue()
    ).map(zio.aws.transcribe.model.UpdateVocabularyFilterResponse.wrap)
      .provideEnvironment(r)
    def createLanguageModel(
        request: zio.aws.transcribe.model.CreateLanguageModelRequest
    ): IO[
      AwsError,
      zio.aws.transcribe.model.CreateLanguageModelResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateLanguageModelRequest,
      CreateLanguageModelResponse
    ]("createLanguageModel", api.createLanguageModel)(request.buildAwsValue())
      .map(zio.aws.transcribe.model.CreateLanguageModelResponse.wrap)
      .provideEnvironment(r)
    def deleteCallAnalyticsCategory(
        request: zio.aws.transcribe.model.DeleteCallAnalyticsCategoryRequest
    ): IO[
      AwsError,
      zio.aws.transcribe.model.DeleteCallAnalyticsCategoryResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteCallAnalyticsCategoryRequest,
      DeleteCallAnalyticsCategoryResponse
    ]("deleteCallAnalyticsCategory", api.deleteCallAnalyticsCategory)(
      request.buildAwsValue()
    ).map(zio.aws.transcribe.model.DeleteCallAnalyticsCategoryResponse.wrap)
      .provideEnvironment(r)
    def getMedicalTranscriptionJob(
        request: zio.aws.transcribe.model.GetMedicalTranscriptionJobRequest
    ): IO[
      AwsError,
      zio.aws.transcribe.model.GetMedicalTranscriptionJobResponse.ReadOnly
    ] = asyncRequestResponse[
      GetMedicalTranscriptionJobRequest,
      GetMedicalTranscriptionJobResponse
    ]("getMedicalTranscriptionJob", api.getMedicalTranscriptionJob)(
      request.buildAwsValue()
    ).map(zio.aws.transcribe.model.GetMedicalTranscriptionJobResponse.wrap)
      .provideEnvironment(r)
    def updateMedicalVocabulary(
        request: zio.aws.transcribe.model.UpdateMedicalVocabularyRequest
    ): IO[
      AwsError,
      zio.aws.transcribe.model.UpdateMedicalVocabularyResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateMedicalVocabularyRequest,
      UpdateMedicalVocabularyResponse
    ]("updateMedicalVocabulary", api.updateMedicalVocabulary)(
      request.buildAwsValue()
    ).map(zio.aws.transcribe.model.UpdateMedicalVocabularyResponse.wrap)
      .provideEnvironment(r)
    def createVocabulary(
        request: zio.aws.transcribe.model.CreateVocabularyRequest
    ): IO[
      AwsError,
      zio.aws.transcribe.model.CreateVocabularyResponse.ReadOnly
    ] = asyncRequestResponse[CreateVocabularyRequest, CreateVocabularyResponse](
      "createVocabulary",
      api.createVocabulary
    )(request.buildAwsValue())
      .map(zio.aws.transcribe.model.CreateVocabularyResponse.wrap)
      .provideEnvironment(r)
    def createMedicalVocabulary(
        request: zio.aws.transcribe.model.CreateMedicalVocabularyRequest
    ): IO[
      AwsError,
      zio.aws.transcribe.model.CreateMedicalVocabularyResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateMedicalVocabularyRequest,
      CreateMedicalVocabularyResponse
    ]("createMedicalVocabulary", api.createMedicalVocabulary)(
      request.buildAwsValue()
    ).map(zio.aws.transcribe.model.CreateMedicalVocabularyResponse.wrap)
      .provideEnvironment(r)
    def getCallAnalyticsCategory(
        request: zio.aws.transcribe.model.GetCallAnalyticsCategoryRequest
    ): IO[
      AwsError,
      zio.aws.transcribe.model.GetCallAnalyticsCategoryResponse.ReadOnly
    ] = asyncRequestResponse[
      GetCallAnalyticsCategoryRequest,
      GetCallAnalyticsCategoryResponse
    ]("getCallAnalyticsCategory", api.getCallAnalyticsCategory)(
      request.buildAwsValue()
    ).map(zio.aws.transcribe.model.GetCallAnalyticsCategoryResponse.wrap)
      .provideEnvironment(r)
    def listMedicalVocabularies(
        request: zio.aws.transcribe.model.ListMedicalVocabulariesRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.transcribe.model.ListMedicalVocabulariesResponse.ReadOnly,
      zio.aws.transcribe.model.VocabularyInfo.ReadOnly
    ]] = asyncPaginatedRequest[
      ListMedicalVocabulariesRequest,
      ListMedicalVocabulariesResponse,
      VocabularyInfo
    ](
      "listMedicalVocabularies",
      api.listMedicalVocabularies,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.vocabularies().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.transcribe.model.ListMedicalVocabulariesResponse.wrap
          )
          .mapOutput(
            _.map(item => zio.aws.transcribe.model.VocabularyInfo.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listMedicalVocabulariesPaginated(
        request: zio.aws.transcribe.model.ListMedicalVocabulariesRequest
    ): IO[
      AwsError,
      zio.aws.transcribe.model.ListMedicalVocabulariesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListMedicalVocabulariesRequest,
      ListMedicalVocabulariesResponse
    ]("listMedicalVocabularies", api.listMedicalVocabularies)(
      request.buildAwsValue()
    ).map(zio.aws.transcribe.model.ListMedicalVocabulariesResponse.wrap)
      .provideEnvironment(r)
    def deleteCallAnalyticsJob(
        request: zio.aws.transcribe.model.DeleteCallAnalyticsJobRequest
    ): IO[
      AwsError,
      zio.aws.transcribe.model.DeleteCallAnalyticsJobResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteCallAnalyticsJobRequest,
      DeleteCallAnalyticsJobResponse
    ]("deleteCallAnalyticsJob", api.deleteCallAnalyticsJob)(
      request.buildAwsValue()
    ).map(zio.aws.transcribe.model.DeleteCallAnalyticsJobResponse.wrap)
      .provideEnvironment(r)
    def getVocabularyFilter(
        request: zio.aws.transcribe.model.GetVocabularyFilterRequest
    ): IO[
      AwsError,
      zio.aws.transcribe.model.GetVocabularyFilterResponse.ReadOnly
    ] = asyncRequestResponse[
      GetVocabularyFilterRequest,
      GetVocabularyFilterResponse
    ]("getVocabularyFilter", api.getVocabularyFilter)(request.buildAwsValue())
      .map(zio.aws.transcribe.model.GetVocabularyFilterResponse.wrap)
      .provideEnvironment(r)
    def updateVocabulary(
        request: zio.aws.transcribe.model.UpdateVocabularyRequest
    ): IO[
      AwsError,
      zio.aws.transcribe.model.UpdateVocabularyResponse.ReadOnly
    ] = asyncRequestResponse[UpdateVocabularyRequest, UpdateVocabularyResponse](
      "updateVocabulary",
      api.updateVocabulary
    )(request.buildAwsValue())
      .map(zio.aws.transcribe.model.UpdateVocabularyResponse.wrap)
      .provideEnvironment(r)
    def listVocabularies(
        request: zio.aws.transcribe.model.ListVocabulariesRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.transcribe.model.ListVocabulariesResponse.ReadOnly,
      zio.aws.transcribe.model.VocabularyInfo.ReadOnly
    ]] = asyncPaginatedRequest[
      ListVocabulariesRequest,
      ListVocabulariesResponse,
      VocabularyInfo
    ](
      "listVocabularies",
      api.listVocabularies,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.vocabularies().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.transcribe.model.ListVocabulariesResponse.wrap)
          .mapOutput(
            _.map(item => zio.aws.transcribe.model.VocabularyInfo.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listVocabulariesPaginated(
        request: zio.aws.transcribe.model.ListVocabulariesRequest
    ): IO[
      AwsError,
      zio.aws.transcribe.model.ListVocabulariesResponse.ReadOnly
    ] = asyncRequestResponse[ListVocabulariesRequest, ListVocabulariesResponse](
      "listVocabularies",
      api.listVocabularies
    )(request.buildAwsValue())
      .map(zio.aws.transcribe.model.ListVocabulariesResponse.wrap)
      .provideEnvironment(r)
    def startCallAnalyticsJob(
        request: zio.aws.transcribe.model.StartCallAnalyticsJobRequest
    ): IO[
      AwsError,
      zio.aws.transcribe.model.StartCallAnalyticsJobResponse.ReadOnly
    ] = asyncRequestResponse[
      StartCallAnalyticsJobRequest,
      StartCallAnalyticsJobResponse
    ]("startCallAnalyticsJob", api.startCallAnalyticsJob)(
      request.buildAwsValue()
    ).map(zio.aws.transcribe.model.StartCallAnalyticsJobResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: zio.aws.transcribe.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.transcribe.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.transcribe.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def createVocabularyFilter(
        request: zio.aws.transcribe.model.CreateVocabularyFilterRequest
    ): IO[
      AwsError,
      zio.aws.transcribe.model.CreateVocabularyFilterResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateVocabularyFilterRequest,
      CreateVocabularyFilterResponse
    ]("createVocabularyFilter", api.createVocabularyFilter)(
      request.buildAwsValue()
    ).map(zio.aws.transcribe.model.CreateVocabularyFilterResponse.wrap)
      .provideEnvironment(r)
    def deleteTranscriptionJob(
        request: zio.aws.transcribe.model.DeleteTranscriptionJobRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteTranscriptionJobRequest,
      DeleteTranscriptionJobResponse
    ]("deleteTranscriptionJob", api.deleteTranscriptionJob)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listTranscriptionJobs(
        request: zio.aws.transcribe.model.ListTranscriptionJobsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.transcribe.model.ListTranscriptionJobsResponse.ReadOnly,
      zio.aws.transcribe.model.TranscriptionJobSummary.ReadOnly
    ]] = asyncPaginatedRequest[
      ListTranscriptionJobsRequest,
      ListTranscriptionJobsResponse,
      TranscriptionJobSummary
    ](
      "listTranscriptionJobs",
      api.listTranscriptionJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.transcriptionJobSummaries().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.transcribe.model.ListTranscriptionJobsResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.transcribe.model.TranscriptionJobSummary.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listTranscriptionJobsPaginated(
        request: zio.aws.transcribe.model.ListTranscriptionJobsRequest
    ): IO[
      AwsError,
      zio.aws.transcribe.model.ListTranscriptionJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTranscriptionJobsRequest,
      ListTranscriptionJobsResponse
    ]("listTranscriptionJobs", api.listTranscriptionJobs)(
      request.buildAwsValue()
    ).map(zio.aws.transcribe.model.ListTranscriptionJobsResponse.wrap)
      .provideEnvironment(r)
    def describeLanguageModel(
        request: zio.aws.transcribe.model.DescribeLanguageModelRequest
    ): IO[
      AwsError,
      zio.aws.transcribe.model.DescribeLanguageModelResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeLanguageModelRequest,
      DescribeLanguageModelResponse
    ]("describeLanguageModel", api.describeLanguageModel)(
      request.buildAwsValue()
    ).map(zio.aws.transcribe.model.DescribeLanguageModelResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.transcribe.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.transcribe.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.transcribe.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def deleteLanguageModel(
        request: zio.aws.transcribe.model.DeleteLanguageModelRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteLanguageModelRequest,
      DeleteLanguageModelResponse
    ]("deleteLanguageModel", api.deleteLanguageModel)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def tagResource(
        request: zio.aws.transcribe.model.TagResourceRequest
    ): IO[AwsError, zio.aws.transcribe.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.transcribe.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def startMedicalTranscriptionJob(
        request: zio.aws.transcribe.model.StartMedicalTranscriptionJobRequest
    ): IO[
      AwsError,
      zio.aws.transcribe.model.StartMedicalTranscriptionJobResponse.ReadOnly
    ] = asyncRequestResponse[
      StartMedicalTranscriptionJobRequest,
      StartMedicalTranscriptionJobResponse
    ]("startMedicalTranscriptionJob", api.startMedicalTranscriptionJob)(
      request.buildAwsValue()
    ).map(zio.aws.transcribe.model.StartMedicalTranscriptionJobResponse.wrap)
      .provideEnvironment(r)
    def listLanguageModels(
        request: zio.aws.transcribe.model.ListLanguageModelsRequest
    ): ZStream[Any, AwsError, zio.aws.transcribe.model.LanguageModel.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListLanguageModelsRequest,
        ListLanguageModelsResponse,
        LanguageModel
      ](
        "listLanguageModels",
        api.listLanguageModels,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.models().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.transcribe.model.LanguageModel.wrap(item))
        .provideEnvironment(r)
    def listLanguageModelsPaginated(
        request: zio.aws.transcribe.model.ListLanguageModelsRequest
    ): IO[
      AwsError,
      zio.aws.transcribe.model.ListLanguageModelsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListLanguageModelsRequest,
      ListLanguageModelsResponse
    ]("listLanguageModels", api.listLanguageModels)(request.buildAwsValue())
      .map(zio.aws.transcribe.model.ListLanguageModelsResponse.wrap)
      .provideEnvironment(r)
    def createCallAnalyticsCategory(
        request: zio.aws.transcribe.model.CreateCallAnalyticsCategoryRequest
    ): IO[
      AwsError,
      zio.aws.transcribe.model.CreateCallAnalyticsCategoryResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateCallAnalyticsCategoryRequest,
      CreateCallAnalyticsCategoryResponse
    ]("createCallAnalyticsCategory", api.createCallAnalyticsCategory)(
      request.buildAwsValue()
    ).map(zio.aws.transcribe.model.CreateCallAnalyticsCategoryResponse.wrap)
      .provideEnvironment(r)
    def getVocabulary(
        request: zio.aws.transcribe.model.GetVocabularyRequest
    ): IO[AwsError, zio.aws.transcribe.model.GetVocabularyResponse.ReadOnly] =
      asyncRequestResponse[GetVocabularyRequest, GetVocabularyResponse](
        "getVocabulary",
        api.getVocabulary
      )(request.buildAwsValue())
        .map(zio.aws.transcribe.model.GetVocabularyResponse.wrap)
        .provideEnvironment(r)
    def getMedicalVocabulary(
        request: zio.aws.transcribe.model.GetMedicalVocabularyRequest
    ): IO[
      AwsError,
      zio.aws.transcribe.model.GetMedicalVocabularyResponse.ReadOnly
    ] = asyncRequestResponse[
      GetMedicalVocabularyRequest,
      GetMedicalVocabularyResponse
    ]("getMedicalVocabulary", api.getMedicalVocabulary)(request.buildAwsValue())
      .map(zio.aws.transcribe.model.GetMedicalVocabularyResponse.wrap)
      .provideEnvironment(r)
    def startTranscriptionJob(
        request: zio.aws.transcribe.model.StartTranscriptionJobRequest
    ): IO[
      AwsError,
      zio.aws.transcribe.model.StartTranscriptionJobResponse.ReadOnly
    ] = asyncRequestResponse[
      StartTranscriptionJobRequest,
      StartTranscriptionJobResponse
    ]("startTranscriptionJob", api.startTranscriptionJob)(
      request.buildAwsValue()
    ).map(zio.aws.transcribe.model.StartTranscriptionJobResponse.wrap)
      .provideEnvironment(r)
    def deleteVocabularyFilter(
        request: zio.aws.transcribe.model.DeleteVocabularyFilterRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteVocabularyFilterRequest,
      DeleteVocabularyFilterResponse
    ]("deleteVocabularyFilter", api.deleteVocabularyFilter)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteMedicalTranscriptionJob(
        request: zio.aws.transcribe.model.DeleteMedicalTranscriptionJobRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteMedicalTranscriptionJobRequest,
      DeleteMedicalTranscriptionJobResponse
    ]("deleteMedicalTranscriptionJob", api.deleteMedicalTranscriptionJob)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listCallAnalyticsCategories(
        request: zio.aws.transcribe.model.ListCallAnalyticsCategoriesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.transcribe.model.CategoryProperties.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListCallAnalyticsCategoriesRequest,
      ListCallAnalyticsCategoriesResponse,
      CategoryProperties
    ](
      "listCallAnalyticsCategories",
      api.listCallAnalyticsCategories,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.categories().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.transcribe.model.CategoryProperties.wrap(item))
      .provideEnvironment(r)
    def listCallAnalyticsCategoriesPaginated(
        request: zio.aws.transcribe.model.ListCallAnalyticsCategoriesRequest
    ): IO[
      AwsError,
      zio.aws.transcribe.model.ListCallAnalyticsCategoriesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListCallAnalyticsCategoriesRequest,
      ListCallAnalyticsCategoriesResponse
    ]("listCallAnalyticsCategories", api.listCallAnalyticsCategories)(
      request.buildAwsValue()
    ).map(zio.aws.transcribe.model.ListCallAnalyticsCategoriesResponse.wrap)
      .provideEnvironment(r)
    def getTranscriptionJob(
        request: zio.aws.transcribe.model.GetTranscriptionJobRequest
    ): IO[
      AwsError,
      zio.aws.transcribe.model.GetTranscriptionJobResponse.ReadOnly
    ] = asyncRequestResponse[
      GetTranscriptionJobRequest,
      GetTranscriptionJobResponse
    ]("getTranscriptionJob", api.getTranscriptionJob)(request.buildAwsValue())
      .map(zio.aws.transcribe.model.GetTranscriptionJobResponse.wrap)
      .provideEnvironment(r)
    def listCallAnalyticsJobs(
        request: zio.aws.transcribe.model.ListCallAnalyticsJobsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.transcribe.model.ListCallAnalyticsJobsResponse.ReadOnly,
      zio.aws.transcribe.model.CallAnalyticsJobSummary.ReadOnly
    ]] = asyncPaginatedRequest[
      ListCallAnalyticsJobsRequest,
      ListCallAnalyticsJobsResponse,
      CallAnalyticsJobSummary
    ](
      "listCallAnalyticsJobs",
      api.listCallAnalyticsJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.callAnalyticsJobSummaries().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.transcribe.model.ListCallAnalyticsJobsResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.transcribe.model.CallAnalyticsJobSummary.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listCallAnalyticsJobsPaginated(
        request: zio.aws.transcribe.model.ListCallAnalyticsJobsRequest
    ): IO[
      AwsError,
      zio.aws.transcribe.model.ListCallAnalyticsJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListCallAnalyticsJobsRequest,
      ListCallAnalyticsJobsResponse
    ]("listCallAnalyticsJobs", api.listCallAnalyticsJobs)(
      request.buildAwsValue()
    ).map(zio.aws.transcribe.model.ListCallAnalyticsJobsResponse.wrap)
      .provideEnvironment(r)
  }
  def listVocabularyFilters(
      request: zio.aws.transcribe.model.ListVocabularyFiltersRequest
  ): ZStream[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.VocabularyFilterInfo.ReadOnly
  ] = ZStream.serviceWithStream(_.listVocabularyFilters(request))
  def listVocabularyFiltersPaginated(
      request: zio.aws.transcribe.model.ListVocabularyFiltersRequest
  ): ZIO[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.ListVocabularyFiltersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVocabularyFiltersPaginated(request))
  def getCallAnalyticsJob(
      request: zio.aws.transcribe.model.GetCallAnalyticsJobRequest
  ): ZIO[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.GetCallAnalyticsJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCallAnalyticsJob(request))
  def deleteMedicalVocabulary(
      request: zio.aws.transcribe.model.DeleteMedicalVocabularyRequest
  ): ZIO[zio.aws.transcribe.Transcribe, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteMedicalVocabulary(request))
  def deleteVocabulary(
      request: zio.aws.transcribe.model.DeleteVocabularyRequest
  ): ZIO[zio.aws.transcribe.Transcribe, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteVocabulary(request))
  def updateCallAnalyticsCategory(
      request: zio.aws.transcribe.model.UpdateCallAnalyticsCategoryRequest
  ): ZIO[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.UpdateCallAnalyticsCategoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateCallAnalyticsCategory(request))
  def listMedicalTranscriptionJobs(
      request: zio.aws.transcribe.model.ListMedicalTranscriptionJobsRequest
  ): ZIO[zio.aws.transcribe.Transcribe, AwsError, StreamingOutputResult[
    Any,
    zio.aws.transcribe.model.ListMedicalTranscriptionJobsResponse.ReadOnly,
    ReadOnly
  ]] = ZIO.serviceWithZIO(_.listMedicalTranscriptionJobs(request))
  def listMedicalTranscriptionJobsPaginated(
      request: zio.aws.transcribe.model.ListMedicalTranscriptionJobsRequest
  ): ZIO[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.ListMedicalTranscriptionJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMedicalTranscriptionJobsPaginated(request))
  def updateVocabularyFilter(
      request: zio.aws.transcribe.model.UpdateVocabularyFilterRequest
  ): ZIO[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.UpdateVocabularyFilterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateVocabularyFilter(request))
  def createLanguageModel(
      request: zio.aws.transcribe.model.CreateLanguageModelRequest
  ): ZIO[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.CreateLanguageModelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLanguageModel(request))
  def deleteCallAnalyticsCategory(
      request: zio.aws.transcribe.model.DeleteCallAnalyticsCategoryRequest
  ): ZIO[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.DeleteCallAnalyticsCategoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCallAnalyticsCategory(request))
  def getMedicalTranscriptionJob(
      request: zio.aws.transcribe.model.GetMedicalTranscriptionJobRequest
  ): ZIO[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.GetMedicalTranscriptionJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMedicalTranscriptionJob(request))
  def updateMedicalVocabulary(
      request: zio.aws.transcribe.model.UpdateMedicalVocabularyRequest
  ): ZIO[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.UpdateMedicalVocabularyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateMedicalVocabulary(request))
  def createVocabulary(
      request: zio.aws.transcribe.model.CreateVocabularyRequest
  ): ZIO[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.CreateVocabularyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVocabulary(request))
  def createMedicalVocabulary(
      request: zio.aws.transcribe.model.CreateMedicalVocabularyRequest
  ): ZIO[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.CreateMedicalVocabularyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMedicalVocabulary(request))
  def getCallAnalyticsCategory(
      request: zio.aws.transcribe.model.GetCallAnalyticsCategoryRequest
  ): ZIO[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.GetCallAnalyticsCategoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCallAnalyticsCategory(request))
  def listMedicalVocabularies(
      request: zio.aws.transcribe.model.ListMedicalVocabulariesRequest
  ): ZIO[zio.aws.transcribe.Transcribe, AwsError, StreamingOutputResult[
    Any,
    zio.aws.transcribe.model.ListMedicalVocabulariesResponse.ReadOnly,
    zio.aws.transcribe.model.VocabularyInfo.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listMedicalVocabularies(request))
  def listMedicalVocabulariesPaginated(
      request: zio.aws.transcribe.model.ListMedicalVocabulariesRequest
  ): ZIO[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.ListMedicalVocabulariesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMedicalVocabulariesPaginated(request))
  def deleteCallAnalyticsJob(
      request: zio.aws.transcribe.model.DeleteCallAnalyticsJobRequest
  ): ZIO[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.DeleteCallAnalyticsJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCallAnalyticsJob(request))
  def getVocabularyFilter(
      request: zio.aws.transcribe.model.GetVocabularyFilterRequest
  ): ZIO[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.GetVocabularyFilterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVocabularyFilter(request))
  def updateVocabulary(
      request: zio.aws.transcribe.model.UpdateVocabularyRequest
  ): ZIO[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.UpdateVocabularyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateVocabulary(request))
  def listVocabularies(
      request: zio.aws.transcribe.model.ListVocabulariesRequest
  ): ZIO[zio.aws.transcribe.Transcribe, AwsError, StreamingOutputResult[
    Any,
    zio.aws.transcribe.model.ListVocabulariesResponse.ReadOnly,
    zio.aws.transcribe.model.VocabularyInfo.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listVocabularies(request))
  def listVocabulariesPaginated(
      request: zio.aws.transcribe.model.ListVocabulariesRequest
  ): ZIO[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.ListVocabulariesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVocabulariesPaginated(request))
  def startCallAnalyticsJob(
      request: zio.aws.transcribe.model.StartCallAnalyticsJobRequest
  ): ZIO[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.StartCallAnalyticsJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startCallAnalyticsJob(request))
  def untagResource(
      request: zio.aws.transcribe.model.UntagResourceRequest
  ): ZIO[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def createVocabularyFilter(
      request: zio.aws.transcribe.model.CreateVocabularyFilterRequest
  ): ZIO[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.CreateVocabularyFilterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVocabularyFilter(request))
  def deleteTranscriptionJob(
      request: zio.aws.transcribe.model.DeleteTranscriptionJobRequest
  ): ZIO[zio.aws.transcribe.Transcribe, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteTranscriptionJob(request))
  def listTranscriptionJobs(
      request: zio.aws.transcribe.model.ListTranscriptionJobsRequest
  ): ZIO[zio.aws.transcribe.Transcribe, AwsError, StreamingOutputResult[
    Any,
    zio.aws.transcribe.model.ListTranscriptionJobsResponse.ReadOnly,
    zio.aws.transcribe.model.TranscriptionJobSummary.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listTranscriptionJobs(request))
  def listTranscriptionJobsPaginated(
      request: zio.aws.transcribe.model.ListTranscriptionJobsRequest
  ): ZIO[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.ListTranscriptionJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTranscriptionJobsPaginated(request))
  def describeLanguageModel(
      request: zio.aws.transcribe.model.DescribeLanguageModelRequest
  ): ZIO[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.DescribeLanguageModelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLanguageModel(request))
  def listTagsForResource(
      request: zio.aws.transcribe.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def deleteLanguageModel(
      request: zio.aws.transcribe.model.DeleteLanguageModelRequest
  ): ZIO[zio.aws.transcribe.Transcribe, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteLanguageModel(request))
  def tagResource(request: zio.aws.transcribe.model.TagResourceRequest): ZIO[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def startMedicalTranscriptionJob(
      request: zio.aws.transcribe.model.StartMedicalTranscriptionJobRequest
  ): ZIO[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.StartMedicalTranscriptionJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startMedicalTranscriptionJob(request))
  def listLanguageModels(
      request: zio.aws.transcribe.model.ListLanguageModelsRequest
  ): ZStream[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.LanguageModel.ReadOnly
  ] = ZStream.serviceWithStream(_.listLanguageModels(request))
  def listLanguageModelsPaginated(
      request: zio.aws.transcribe.model.ListLanguageModelsRequest
  ): ZIO[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.ListLanguageModelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLanguageModelsPaginated(request))
  def createCallAnalyticsCategory(
      request: zio.aws.transcribe.model.CreateCallAnalyticsCategoryRequest
  ): ZIO[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.CreateCallAnalyticsCategoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCallAnalyticsCategory(request))
  def getVocabulary(
      request: zio.aws.transcribe.model.GetVocabularyRequest
  ): ZIO[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.GetVocabularyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVocabulary(request))
  def getMedicalVocabulary(
      request: zio.aws.transcribe.model.GetMedicalVocabularyRequest
  ): ZIO[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.GetMedicalVocabularyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMedicalVocabulary(request))
  def startTranscriptionJob(
      request: zio.aws.transcribe.model.StartTranscriptionJobRequest
  ): ZIO[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.StartTranscriptionJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startTranscriptionJob(request))
  def deleteVocabularyFilter(
      request: zio.aws.transcribe.model.DeleteVocabularyFilterRequest
  ): ZIO[zio.aws.transcribe.Transcribe, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteVocabularyFilter(request))
  def deleteMedicalTranscriptionJob(
      request: zio.aws.transcribe.model.DeleteMedicalTranscriptionJobRequest
  ): ZIO[zio.aws.transcribe.Transcribe, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteMedicalTranscriptionJob(request))
  def listCallAnalyticsCategories(
      request: zio.aws.transcribe.model.ListCallAnalyticsCategoriesRequest
  ): ZStream[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.CategoryProperties.ReadOnly
  ] = ZStream.serviceWithStream(_.listCallAnalyticsCategories(request))
  def listCallAnalyticsCategoriesPaginated(
      request: zio.aws.transcribe.model.ListCallAnalyticsCategoriesRequest
  ): ZIO[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.ListCallAnalyticsCategoriesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCallAnalyticsCategoriesPaginated(request))
  def getTranscriptionJob(
      request: zio.aws.transcribe.model.GetTranscriptionJobRequest
  ): ZIO[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.GetTranscriptionJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTranscriptionJob(request))
  def listCallAnalyticsJobs(
      request: zio.aws.transcribe.model.ListCallAnalyticsJobsRequest
  ): ZIO[zio.aws.transcribe.Transcribe, AwsError, StreamingOutputResult[
    Any,
    zio.aws.transcribe.model.ListCallAnalyticsJobsResponse.ReadOnly,
    zio.aws.transcribe.model.CallAnalyticsJobSummary.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listCallAnalyticsJobs(request))
  def listCallAnalyticsJobsPaginated(
      request: zio.aws.transcribe.model.ListCallAnalyticsJobsRequest
  ): ZIO[
    zio.aws.transcribe.Transcribe,
    AwsError,
    zio.aws.transcribe.model.ListCallAnalyticsJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCallAnalyticsJobsPaginated(request))
}
