package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Rule(
    nonTalkTimeFilter: Option[zio.aws.transcribe.model.NonTalkTimeFilter] =
      None,
    interruptionFilter: Option[zio.aws.transcribe.model.InterruptionFilter] =
      None,
    transcriptFilter: Option[zio.aws.transcribe.model.TranscriptFilter] = None,
    sentimentFilter: Option[zio.aws.transcribe.model.SentimentFilter] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.transcribe.model.Rule = {
    import Rule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.Rule
      .builder()
      .optionallyWith(nonTalkTimeFilter.map(value => value.buildAwsValue()))(
        _.nonTalkTimeFilter
      )
      .optionallyWith(interruptionFilter.map(value => value.buildAwsValue()))(
        _.interruptionFilter
      )
      .optionallyWith(transcriptFilter.map(value => value.buildAwsValue()))(
        _.transcriptFilter
      )
      .optionallyWith(sentimentFilter.map(value => value.buildAwsValue()))(
        _.sentimentFilter
      )
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.Rule.ReadOnly =
    zio.aws.transcribe.model.Rule.wrap(buildAwsValue())
}
object Rule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.transcribe.model.Rule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.Rule =
      zio.aws.transcribe.model.Rule(
        nonTalkTimeFilter.map(value => value.asEditable),
        interruptionFilter.map(value => value.asEditable),
        transcriptFilter.map(value => value.asEditable),
        sentimentFilter.map(value => value.asEditable)
      )
    def nonTalkTimeFilter
        : Option[zio.aws.transcribe.model.NonTalkTimeFilter.ReadOnly]
    def interruptionFilter
        : Option[zio.aws.transcribe.model.InterruptionFilter.ReadOnly]
    def transcriptFilter
        : Option[zio.aws.transcribe.model.TranscriptFilter.ReadOnly]
    def sentimentFilter
        : Option[zio.aws.transcribe.model.SentimentFilter.ReadOnly]
    def getNonTalkTimeFilter: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.NonTalkTimeFilter.ReadOnly
    ] = AwsError.unwrapOptionField("nonTalkTimeFilter", nonTalkTimeFilter)
    def getInterruptionFilter: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.InterruptionFilter.ReadOnly
    ] = AwsError.unwrapOptionField("interruptionFilter", interruptionFilter)
    def getTranscriptFilter: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.TranscriptFilter.ReadOnly
    ] = AwsError.unwrapOptionField("transcriptFilter", transcriptFilter)
    def getSentimentFilter: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.SentimentFilter.ReadOnly
    ] = AwsError.unwrapOptionField("sentimentFilter", sentimentFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.Rule
  ) extends zio.aws.transcribe.model.Rule.ReadOnly {
    override val nonTalkTimeFilter
        : Option[zio.aws.transcribe.model.NonTalkTimeFilter.ReadOnly] = scala
      .Option(impl.nonTalkTimeFilter())
      .map(value => zio.aws.transcribe.model.NonTalkTimeFilter.wrap(value))
    override val interruptionFilter
        : Option[zio.aws.transcribe.model.InterruptionFilter.ReadOnly] = scala
      .Option(impl.interruptionFilter())
      .map(value => zio.aws.transcribe.model.InterruptionFilter.wrap(value))
    override val transcriptFilter
        : Option[zio.aws.transcribe.model.TranscriptFilter.ReadOnly] = scala
      .Option(impl.transcriptFilter())
      .map(value => zio.aws.transcribe.model.TranscriptFilter.wrap(value))
    override val sentimentFilter
        : Option[zio.aws.transcribe.model.SentimentFilter.ReadOnly] = scala
      .Option(impl.sentimentFilter())
      .map(value => zio.aws.transcribe.model.SentimentFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.Rule
  ): zio.aws.transcribe.model.Rule.ReadOnly = new Wrapper(impl)
}
