package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTranscriptionJobsResponse(
    status: Option[zio.aws.transcribe.model.TranscriptionJobStatus] = None,
    nextToken: Option[NextToken] = None,
    transcriptionJobSummaries: Option[
      Iterable[zio.aws.transcribe.model.TranscriptionJobSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsResponse = {
    import ListTranscriptionJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsResponse
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        transcriptionJobSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.transcriptionJobSummaries)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.ListTranscriptionJobsResponse.ReadOnly =
    zio.aws.transcribe.model.ListTranscriptionJobsResponse.wrap(buildAwsValue())
}
object ListTranscriptionJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.ListTranscriptionJobsResponse =
      zio.aws.transcribe.model.ListTranscriptionJobsResponse(
        status.map(value => value),
        nextToken.map(value => value),
        transcriptionJobSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def status: Option[zio.aws.transcribe.model.TranscriptionJobStatus]
    def nextToken: Option[NextToken]
    def transcriptionJobSummaries: Option[
      List[zio.aws.transcribe.model.TranscriptionJobSummary.ReadOnly]
    ]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.transcribe.model.TranscriptionJobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTranscriptionJobSummaries: ZIO[Any, AwsError, List[
      zio.aws.transcribe.model.TranscriptionJobSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "transcriptionJobSummaries",
      transcriptionJobSummaries
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsResponse
  ) extends zio.aws.transcribe.model.ListTranscriptionJobsResponse.ReadOnly {
    override val status
        : Option[zio.aws.transcribe.model.TranscriptionJobStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.transcribe.model.TranscriptionJobStatus.wrap(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.transcribe.model.primitives.NextToken(value))
    override val transcriptionJobSummaries: Option[
      List[zio.aws.transcribe.model.TranscriptionJobSummary.ReadOnly]
    ] = scala
      .Option(impl.transcriptionJobSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transcribe.model.TranscriptionJobSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.ListTranscriptionJobsResponse
  ): zio.aws.transcribe.model.ListTranscriptionJobsResponse.ReadOnly =
    new Wrapper(impl)
}
