package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.TimestampMilliseconds
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class InterruptionFilter(
    threshold: Option[TimestampMilliseconds] = None,
    participantRole: Option[zio.aws.transcribe.model.ParticipantRole] = None,
    absoluteTimeRange: Option[zio.aws.transcribe.model.AbsoluteTimeRange] =
      None,
    relativeTimeRange: Option[zio.aws.transcribe.model.RelativeTimeRange] =
      None,
    negate: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.InterruptionFilter = {
    import InterruptionFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.InterruptionFilter
      .builder()
      .optionallyWith(
        threshold.map(value =>
          TimestampMilliseconds.unwrap(value): java.lang.Long
        )
      )(_.threshold)
      .optionallyWith(participantRole.map(value => value.unwrap))(
        _.participantRole
      )
      .optionallyWith(absoluteTimeRange.map(value => value.buildAwsValue()))(
        _.absoluteTimeRange
      )
      .optionallyWith(relativeTimeRange.map(value => value.buildAwsValue()))(
        _.relativeTimeRange
      )
      .optionallyWith(negate.map(value => value: java.lang.Boolean))(_.negate)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.InterruptionFilter.ReadOnly =
    zio.aws.transcribe.model.InterruptionFilter.wrap(buildAwsValue())
}
object InterruptionFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.InterruptionFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.InterruptionFilter =
      zio.aws.transcribe.model.InterruptionFilter(
        threshold.map(value => value),
        participantRole.map(value => value),
        absoluteTimeRange.map(value => value.asEditable),
        relativeTimeRange.map(value => value.asEditable),
        negate.map(value => value)
      )
    def threshold: Option[TimestampMilliseconds]
    def participantRole: Option[zio.aws.transcribe.model.ParticipantRole]
    def absoluteTimeRange
        : Option[zio.aws.transcribe.model.AbsoluteTimeRange.ReadOnly]
    def relativeTimeRange
        : Option[zio.aws.transcribe.model.RelativeTimeRange.ReadOnly]
    def negate: Option[Boolean]
    def getThreshold: ZIO[Any, AwsError, TimestampMilliseconds] =
      AwsError.unwrapOptionField("threshold", threshold)
    def getParticipantRole
        : ZIO[Any, AwsError, zio.aws.transcribe.model.ParticipantRole] =
      AwsError.unwrapOptionField("participantRole", participantRole)
    def getAbsoluteTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.AbsoluteTimeRange.ReadOnly
    ] = AwsError.unwrapOptionField("absoluteTimeRange", absoluteTimeRange)
    def getRelativeTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.RelativeTimeRange.ReadOnly
    ] = AwsError.unwrapOptionField("relativeTimeRange", relativeTimeRange)
    def getNegate: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("negate", negate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.InterruptionFilter
  ) extends zio.aws.transcribe.model.InterruptionFilter.ReadOnly {
    override val threshold: Option[TimestampMilliseconds] = scala
      .Option(impl.threshold())
      .map(value =>
        zio.aws.transcribe.model.primitives.TimestampMilliseconds(value)
      )
    override val participantRole
        : Option[zio.aws.transcribe.model.ParticipantRole] = scala
      .Option(impl.participantRole())
      .map(value => zio.aws.transcribe.model.ParticipantRole.wrap(value))
    override val absoluteTimeRange
        : Option[zio.aws.transcribe.model.AbsoluteTimeRange.ReadOnly] = scala
      .Option(impl.absoluteTimeRange())
      .map(value => zio.aws.transcribe.model.AbsoluteTimeRange.wrap(value))
    override val relativeTimeRange
        : Option[zio.aws.transcribe.model.RelativeTimeRange.ReadOnly] = scala
      .Option(impl.relativeTimeRange())
      .map(value => zio.aws.transcribe.model.RelativeTimeRange.wrap(value))
    override val negate: Option[Boolean] =
      scala.Option(impl.negate()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.InterruptionFilter
  ): zio.aws.transcribe.model.InterruptionFilter.ReadOnly = new Wrapper(impl)
}
