package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.{DateTime, VocabularyFilterName}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class CreateVocabularyFilterResponse(
    vocabularyFilterName: Option[VocabularyFilterName] = None,
    languageCode: Option[zio.aws.transcribe.model.LanguageCode] = None,
    lastModifiedTime: Option[DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.CreateVocabularyFilterResponse = {
    import CreateVocabularyFilterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.CreateVocabularyFilterResponse
      .builder()
      .optionallyWith(
        vocabularyFilterName.map(value =>
          VocabularyFilterName.unwrap(value): java.lang.String
        )
      )(_.vocabularyFilterName)
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(
        lastModifiedTime.map(value => DateTime.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.CreateVocabularyFilterResponse.ReadOnly =
    zio.aws.transcribe.model.CreateVocabularyFilterResponse
      .wrap(buildAwsValue())
}
object CreateVocabularyFilterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.CreateVocabularyFilterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.CreateVocabularyFilterResponse =
      zio.aws.transcribe.model.CreateVocabularyFilterResponse(
        vocabularyFilterName.map(value => value),
        languageCode.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def vocabularyFilterName: Option[VocabularyFilterName]
    def languageCode: Option[zio.aws.transcribe.model.LanguageCode]
    def lastModifiedTime: Option[DateTime]
    def getVocabularyFilterName: ZIO[Any, AwsError, VocabularyFilterName] =
      AwsError.unwrapOptionField("vocabularyFilterName", vocabularyFilterName)
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.transcribe.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getLastModifiedTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.CreateVocabularyFilterResponse
  ) extends zio.aws.transcribe.model.CreateVocabularyFilterResponse.ReadOnly {
    override val vocabularyFilterName: Option[VocabularyFilterName] = scala
      .Option(impl.vocabularyFilterName())
      .map(value =>
        zio.aws.transcribe.model.primitives.VocabularyFilterName(value)
      )
    override val languageCode: Option[zio.aws.transcribe.model.LanguageCode] =
      scala
        .Option(impl.languageCode())
        .map(value => zio.aws.transcribe.model.LanguageCode.wrap(value))
    override val lastModifiedTime: Option[DateTime] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.CreateVocabularyFilterResponse
  ): zio.aws.transcribe.model.CreateVocabularyFilterResponse.ReadOnly =
    new Wrapper(impl)
}
