package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.{
  FailureReason,
  DateTime,
  CallAnalyticsJobName
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class CallAnalyticsJobSummary(
    callAnalyticsJobName: Option[CallAnalyticsJobName] = None,
    creationTime: Option[DateTime] = None,
    startTime: Option[DateTime] = None,
    completionTime: Option[DateTime] = None,
    languageCode: Option[zio.aws.transcribe.model.LanguageCode] = None,
    callAnalyticsJobStatus: Option[
      zio.aws.transcribe.model.CallAnalyticsJobStatus
    ] = None,
    failureReason: Option[FailureReason] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobSummary = {
    import CallAnalyticsJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobSummary
      .builder()
      .optionallyWith(
        callAnalyticsJobName.map(value =>
          CallAnalyticsJobName.unwrap(value): java.lang.String
        )
      )(_.callAnalyticsJobName)
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(startTime.map(value => DateTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(
        completionTime.map(value => DateTime.unwrap(value): Instant)
      )(_.completionTime)
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(callAnalyticsJobStatus.map(value => value.unwrap))(
        _.callAnalyticsJobStatus
      )
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.CallAnalyticsJobSummary.ReadOnly =
    zio.aws.transcribe.model.CallAnalyticsJobSummary.wrap(buildAwsValue())
}
object CallAnalyticsJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.CallAnalyticsJobSummary =
      zio.aws.transcribe.model.CallAnalyticsJobSummary(
        callAnalyticsJobName.map(value => value),
        creationTime.map(value => value),
        startTime.map(value => value),
        completionTime.map(value => value),
        languageCode.map(value => value),
        callAnalyticsJobStatus.map(value => value),
        failureReason.map(value => value)
      )
    def callAnalyticsJobName: Option[CallAnalyticsJobName]
    def creationTime: Option[DateTime]
    def startTime: Option[DateTime]
    def completionTime: Option[DateTime]
    def languageCode: Option[zio.aws.transcribe.model.LanguageCode]
    def callAnalyticsJobStatus
        : Option[zio.aws.transcribe.model.CallAnalyticsJobStatus]
    def failureReason: Option[FailureReason]
    def getCallAnalyticsJobName: ZIO[Any, AwsError, CallAnalyticsJobName] =
      AwsError.unwrapOptionField("callAnalyticsJobName", callAnalyticsJobName)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getCompletionTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("completionTime", completionTime)
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.transcribe.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getCallAnalyticsJobStatus
        : ZIO[Any, AwsError, zio.aws.transcribe.model.CallAnalyticsJobStatus] =
      AwsError.unwrapOptionField(
        "callAnalyticsJobStatus",
        callAnalyticsJobStatus
      )
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobSummary
  ) extends zio.aws.transcribe.model.CallAnalyticsJobSummary.ReadOnly {
    override val callAnalyticsJobName: Option[CallAnalyticsJobName] = scala
      .Option(impl.callAnalyticsJobName())
      .map(value =>
        zio.aws.transcribe.model.primitives.CallAnalyticsJobName(value)
      )
    override val creationTime: Option[DateTime] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val startTime: Option[DateTime] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val completionTime: Option[DateTime] = scala
      .Option(impl.completionTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val languageCode: Option[zio.aws.transcribe.model.LanguageCode] =
      scala
        .Option(impl.languageCode())
        .map(value => zio.aws.transcribe.model.LanguageCode.wrap(value))
    override val callAnalyticsJobStatus
        : Option[zio.aws.transcribe.model.CallAnalyticsJobStatus] = scala
      .Option(impl.callAnalyticsJobStatus())
      .map(value => zio.aws.transcribe.model.CallAnalyticsJobStatus.wrap(value))
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.transcribe.model.primitives.FailureReason(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobSummary
  ): zio.aws.transcribe.model.CallAnalyticsJobSummary.ReadOnly = new Wrapper(
    impl
  )
}
