package zio.aws.transcribe.model
import java.lang.Integer
import zio.ZIO
import zio.aws.transcribe.model.primitives.{
  VocabularyFilterName,
  MaxAlternatives,
  MaxSpeakers,
  VocabularyName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Settings(
    vocabularyName: Option[VocabularyName] = None,
    showSpeakerLabels: Option[Boolean] = None,
    maxSpeakerLabels: Option[MaxSpeakers] = None,
    channelIdentification: Option[Boolean] = None,
    showAlternatives: Option[Boolean] = None,
    maxAlternatives: Option[MaxAlternatives] = None,
    vocabularyFilterName: Option[VocabularyFilterName] = None,
    vocabularyFilterMethod: Option[
      zio.aws.transcribe.model.VocabularyFilterMethod
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.Settings = {
    import Settings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.Settings
      .builder()
      .optionallyWith(
        vocabularyName.map(value =>
          VocabularyName.unwrap(value): java.lang.String
        )
      )(_.vocabularyName)
      .optionallyWith(showSpeakerLabels.map(value => value: java.lang.Boolean))(
        _.showSpeakerLabels
      )
      .optionallyWith(
        maxSpeakerLabels.map(value => MaxSpeakers.unwrap(value): Integer)
      )(_.maxSpeakerLabels)
      .optionallyWith(
        channelIdentification.map(value => value: java.lang.Boolean)
      )(_.channelIdentification)
      .optionallyWith(showAlternatives.map(value => value: java.lang.Boolean))(
        _.showAlternatives
      )
      .optionallyWith(
        maxAlternatives.map(value => MaxAlternatives.unwrap(value): Integer)
      )(_.maxAlternatives)
      .optionallyWith(
        vocabularyFilterName.map(value =>
          VocabularyFilterName.unwrap(value): java.lang.String
        )
      )(_.vocabularyFilterName)
      .optionallyWith(vocabularyFilterMethod.map(value => value.unwrap))(
        _.vocabularyFilterMethod
      )
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.Settings.ReadOnly =
    zio.aws.transcribe.model.Settings.wrap(buildAwsValue())
}
object Settings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.Settings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.Settings =
      zio.aws.transcribe.model.Settings(
        vocabularyName.map(value => value),
        showSpeakerLabels.map(value => value),
        maxSpeakerLabels.map(value => value),
        channelIdentification.map(value => value),
        showAlternatives.map(value => value),
        maxAlternatives.map(value => value),
        vocabularyFilterName.map(value => value),
        vocabularyFilterMethod.map(value => value)
      )
    def vocabularyName: Option[VocabularyName]
    def showSpeakerLabels: Option[Boolean]
    def maxSpeakerLabels: Option[MaxSpeakers]
    def channelIdentification: Option[Boolean]
    def showAlternatives: Option[Boolean]
    def maxAlternatives: Option[MaxAlternatives]
    def vocabularyFilterName: Option[VocabularyFilterName]
    def vocabularyFilterMethod
        : Option[zio.aws.transcribe.model.VocabularyFilterMethod]
    def getVocabularyName: ZIO[Any, AwsError, VocabularyName] =
      AwsError.unwrapOptionField("vocabularyName", vocabularyName)
    def getShowSpeakerLabels: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("showSpeakerLabels", showSpeakerLabels)
    def getMaxSpeakerLabels: ZIO[Any, AwsError, MaxSpeakers] =
      AwsError.unwrapOptionField("maxSpeakerLabels", maxSpeakerLabels)
    def getChannelIdentification: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("channelIdentification", channelIdentification)
    def getShowAlternatives: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("showAlternatives", showAlternatives)
    def getMaxAlternatives: ZIO[Any, AwsError, MaxAlternatives] =
      AwsError.unwrapOptionField("maxAlternatives", maxAlternatives)
    def getVocabularyFilterName: ZIO[Any, AwsError, VocabularyFilterName] =
      AwsError.unwrapOptionField("vocabularyFilterName", vocabularyFilterName)
    def getVocabularyFilterMethod
        : ZIO[Any, AwsError, zio.aws.transcribe.model.VocabularyFilterMethod] =
      AwsError.unwrapOptionField(
        "vocabularyFilterMethod",
        vocabularyFilterMethod
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.Settings
  ) extends zio.aws.transcribe.model.Settings.ReadOnly {
    override val vocabularyName: Option[VocabularyName] = scala
      .Option(impl.vocabularyName())
      .map(value => zio.aws.transcribe.model.primitives.VocabularyName(value))
    override val showSpeakerLabels: Option[Boolean] =
      scala.Option(impl.showSpeakerLabels()).map(value => value: Boolean)
    override val maxSpeakerLabels: Option[MaxSpeakers] = scala
      .Option(impl.maxSpeakerLabels())
      .map(value => zio.aws.transcribe.model.primitives.MaxSpeakers(value))
    override val channelIdentification: Option[Boolean] =
      scala.Option(impl.channelIdentification()).map(value => value: Boolean)
    override val showAlternatives: Option[Boolean] =
      scala.Option(impl.showAlternatives()).map(value => value: Boolean)
    override val maxAlternatives: Option[MaxAlternatives] = scala
      .Option(impl.maxAlternatives())
      .map(value => zio.aws.transcribe.model.primitives.MaxAlternatives(value))
    override val vocabularyFilterName: Option[VocabularyFilterName] = scala
      .Option(impl.vocabularyFilterName())
      .map(value =>
        zio.aws.transcribe.model.primitives.VocabularyFilterName(value)
      )
    override val vocabularyFilterMethod
        : Option[zio.aws.transcribe.model.VocabularyFilterMethod] = scala
      .Option(impl.vocabularyFilterMethod())
      .map(value => zio.aws.transcribe.model.VocabularyFilterMethod.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.Settings
  ): zio.aws.transcribe.model.Settings.ReadOnly = new Wrapper(impl)
}
