package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListVocabulariesResponse(
    status: Option[zio.aws.transcribe.model.VocabularyState] = None,
    nextToken: Option[NextToken] = None,
    vocabularies: Option[Iterable[zio.aws.transcribe.model.VocabularyInfo]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.ListVocabulariesResponse = {
    import ListVocabulariesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.ListVocabulariesResponse
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        vocabularies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vocabularies)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.ListVocabulariesResponse.ReadOnly =
    zio.aws.transcribe.model.ListVocabulariesResponse.wrap(buildAwsValue())
}
object ListVocabulariesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.ListVocabulariesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.ListVocabulariesResponse =
      zio.aws.transcribe.model.ListVocabulariesResponse(
        status.map(value => value),
        nextToken.map(value => value),
        vocabularies.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def status: Option[zio.aws.transcribe.model.VocabularyState]
    def nextToken: Option[NextToken]
    def vocabularies
        : Option[List[zio.aws.transcribe.model.VocabularyInfo.ReadOnly]]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.transcribe.model.VocabularyState] =
      AwsError.unwrapOptionField("status", status)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getVocabularies: ZIO[Any, AwsError, List[
      zio.aws.transcribe.model.VocabularyInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("vocabularies", vocabularies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.ListVocabulariesResponse
  ) extends zio.aws.transcribe.model.ListVocabulariesResponse.ReadOnly {
    override val status: Option[zio.aws.transcribe.model.VocabularyState] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.transcribe.model.VocabularyState.wrap(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.transcribe.model.primitives.NextToken(value))
    override val vocabularies
        : Option[List[zio.aws.transcribe.model.VocabularyInfo.ReadOnly]] = scala
      .Option(impl.vocabularies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transcribe.model.VocabularyInfo.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.ListVocabulariesResponse
  ): zio.aws.transcribe.model.ListVocabulariesResponse.ReadOnly = new Wrapper(
    impl
  )
}
