package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.{
  Uri,
  FailureReason,
  DateTime,
  VocabularyName
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class GetVocabularyResponse(
    vocabularyName: Option[VocabularyName] = None,
    languageCode: Option[zio.aws.transcribe.model.LanguageCode] = None,
    vocabularyState: Option[zio.aws.transcribe.model.VocabularyState] = None,
    lastModifiedTime: Option[DateTime] = None,
    failureReason: Option[FailureReason] = None,
    downloadUri: Option[Uri] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.GetVocabularyResponse = {
    import GetVocabularyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.GetVocabularyResponse
      .builder()
      .optionallyWith(
        vocabularyName.map(value =>
          VocabularyName.unwrap(value): java.lang.String
        )
      )(_.vocabularyName)
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(vocabularyState.map(value => value.unwrap))(
        _.vocabularyState
      )
      .optionallyWith(
        lastModifiedTime.map(value => DateTime.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        downloadUri.map(value => Uri.unwrap(value): java.lang.String)
      )(_.downloadUri)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.GetVocabularyResponse.ReadOnly =
    zio.aws.transcribe.model.GetVocabularyResponse.wrap(buildAwsValue())
}
object GetVocabularyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.GetVocabularyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.GetVocabularyResponse =
      zio.aws.transcribe.model.GetVocabularyResponse(
        vocabularyName.map(value => value),
        languageCode.map(value => value),
        vocabularyState.map(value => value),
        lastModifiedTime.map(value => value),
        failureReason.map(value => value),
        downloadUri.map(value => value)
      )
    def vocabularyName: Option[VocabularyName]
    def languageCode: Option[zio.aws.transcribe.model.LanguageCode]
    def vocabularyState: Option[zio.aws.transcribe.model.VocabularyState]
    def lastModifiedTime: Option[DateTime]
    def failureReason: Option[FailureReason]
    def downloadUri: Option[Uri]
    def getVocabularyName: ZIO[Any, AwsError, VocabularyName] =
      AwsError.unwrapOptionField("vocabularyName", vocabularyName)
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.transcribe.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getVocabularyState
        : ZIO[Any, AwsError, zio.aws.transcribe.model.VocabularyState] =
      AwsError.unwrapOptionField("vocabularyState", vocabularyState)
    def getLastModifiedTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getDownloadUri: ZIO[Any, AwsError, Uri] =
      AwsError.unwrapOptionField("downloadUri", downloadUri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.GetVocabularyResponse
  ) extends zio.aws.transcribe.model.GetVocabularyResponse.ReadOnly {
    override val vocabularyName: Option[VocabularyName] = scala
      .Option(impl.vocabularyName())
      .map(value => zio.aws.transcribe.model.primitives.VocabularyName(value))
    override val languageCode: Option[zio.aws.transcribe.model.LanguageCode] =
      scala
        .Option(impl.languageCode())
        .map(value => zio.aws.transcribe.model.LanguageCode.wrap(value))
    override val vocabularyState
        : Option[zio.aws.transcribe.model.VocabularyState] = scala
      .Option(impl.vocabularyState())
      .map(value => zio.aws.transcribe.model.VocabularyState.wrap(value))
    override val lastModifiedTime: Option[DateTime] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.transcribe.model.primitives.FailureReason(value))
    override val downloadUri: Option[Uri] = scala
      .Option(impl.downloadUri())
      .map(value => zio.aws.transcribe.model.primitives.Uri(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.GetVocabularyResponse
  ): zio.aws.transcribe.model.GetVocabularyResponse.ReadOnly = new Wrapper(impl)
}
