package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.CategoryName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteCallAnalyticsCategoryRequest(
    categoryName: CategoryName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.DeleteCallAnalyticsCategoryRequest = {
    import DeleteCallAnalyticsCategoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.DeleteCallAnalyticsCategoryRequest
      .builder()
      .categoryName(CategoryName.unwrap(categoryName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.DeleteCallAnalyticsCategoryRequest.ReadOnly =
    zio.aws.transcribe.model.DeleteCallAnalyticsCategoryRequest
      .wrap(buildAwsValue())
}
object DeleteCallAnalyticsCategoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.DeleteCallAnalyticsCategoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.transcribe.model.DeleteCallAnalyticsCategoryRequest =
      zio.aws.transcribe.model.DeleteCallAnalyticsCategoryRequest(categoryName)
    def categoryName: CategoryName
    def getCategoryName: ZIO[Any, Nothing, CategoryName] =
      ZIO.succeed(categoryName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.DeleteCallAnalyticsCategoryRequest
  ) extends zio.aws.transcribe.model.DeleteCallAnalyticsCategoryRequest.ReadOnly {
    override val categoryName: CategoryName =
      zio.aws.transcribe.model.primitives.CategoryName(impl.categoryName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.DeleteCallAnalyticsCategoryRequest
  ): zio.aws.transcribe.model.DeleteCallAnalyticsCategoryRequest.ReadOnly =
    new Wrapper(impl)
}
