package zio.aws.transcribe
import zio.aws.transcribe.model.MedicalTranscriptionJobSummary.ReadOnly
import software.amazon.awssdk.services.transcribe.TranscribeAsyncClient
import zio.mock.{Proxy, Mock}
import zio.aws.transcribe.model.{
  GetMedicalTranscriptionJobRequest,
  DeleteMedicalVocabularyRequest,
  DeleteLanguageModelRequest,
  ListTranscriptionJobsRequest,
  CreateCallAnalyticsCategoryRequest,
  CreateVocabularyFilterRequest,
  GetMedicalVocabularyRequest,
  DeleteTranscriptionJobRequest,
  CreateVocabularyRequest,
  CreateMedicalVocabularyRequest,
  DeleteCallAnalyticsJobRequest,
  DeleteCallAnalyticsCategoryRequest,
  ListCallAnalyticsCategoriesRequest,
  DeleteMedicalTranscriptionJobRequest,
  ListMedicalTranscriptionJobsRequest,
  ListCallAnalyticsJobsRequest,
  ListTagsForResourceRequest,
  DescribeLanguageModelRequest,
  ListVocabularyFiltersRequest,
  UpdateVocabularyRequest,
  DeleteVocabularyFilterRequest,
  StartMedicalTranscriptionJobRequest,
  UpdateVocabularyFilterRequest,
  GetCallAnalyticsJobRequest,
  StartTranscriptionJobRequest,
  GetVocabularyFilterRequest,
  ListMedicalVocabulariesRequest,
  GetCallAnalyticsCategoryRequest,
  UntagResourceRequest,
  DeleteVocabularyRequest,
  StartCallAnalyticsJobRequest,
  UpdateCallAnalyticsCategoryRequest,
  GetVocabularyRequest,
  CreateLanguageModelRequest,
  ListVocabulariesRequest,
  TagResourceRequest,
  UpdateMedicalVocabularyRequest,
  GetTranscriptionJobRequest,
  ListLanguageModelsRequest
}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object TranscribeMock extends Mock[Transcribe] {
  object ListVocabularyFilters
      extends Stream[
        ListVocabularyFiltersRequest,
        AwsError,
        zio.aws.transcribe.model.VocabularyFilterInfo.ReadOnly
      ]
  object ListVocabularyFiltersPaginated
      extends Effect[
        ListVocabularyFiltersRequest,
        AwsError,
        zio.aws.transcribe.model.ListVocabularyFiltersResponse.ReadOnly
      ]
  object GetCallAnalyticsJob
      extends Effect[
        GetCallAnalyticsJobRequest,
        AwsError,
        zio.aws.transcribe.model.GetCallAnalyticsJobResponse.ReadOnly
      ]
  object DeleteMedicalVocabulary
      extends Effect[DeleteMedicalVocabularyRequest, AwsError, Unit]
  object DeleteVocabulary
      extends Effect[DeleteVocabularyRequest, AwsError, Unit]
  object UpdateCallAnalyticsCategory
      extends Effect[
        UpdateCallAnalyticsCategoryRequest,
        AwsError,
        zio.aws.transcribe.model.UpdateCallAnalyticsCategoryResponse.ReadOnly
      ]
  object ListMedicalTranscriptionJobs
      extends Effect[
        ListMedicalTranscriptionJobsRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.transcribe.model.ListMedicalTranscriptionJobsResponse.ReadOnly,
          ReadOnly
        ]
      ]
  object ListMedicalTranscriptionJobsPaginated
      extends Effect[
        ListMedicalTranscriptionJobsRequest,
        AwsError,
        zio.aws.transcribe.model.ListMedicalTranscriptionJobsResponse.ReadOnly
      ]
  object UpdateVocabularyFilter
      extends Effect[
        UpdateVocabularyFilterRequest,
        AwsError,
        zio.aws.transcribe.model.UpdateVocabularyFilterResponse.ReadOnly
      ]
  object CreateLanguageModel
      extends Effect[
        CreateLanguageModelRequest,
        AwsError,
        zio.aws.transcribe.model.CreateLanguageModelResponse.ReadOnly
      ]
  object DeleteCallAnalyticsCategory
      extends Effect[
        DeleteCallAnalyticsCategoryRequest,
        AwsError,
        zio.aws.transcribe.model.DeleteCallAnalyticsCategoryResponse.ReadOnly
      ]
  object GetMedicalTranscriptionJob
      extends Effect[
        GetMedicalTranscriptionJobRequest,
        AwsError,
        zio.aws.transcribe.model.GetMedicalTranscriptionJobResponse.ReadOnly
      ]
  object UpdateMedicalVocabulary
      extends Effect[
        UpdateMedicalVocabularyRequest,
        AwsError,
        zio.aws.transcribe.model.UpdateMedicalVocabularyResponse.ReadOnly
      ]
  object CreateVocabulary
      extends Effect[
        CreateVocabularyRequest,
        AwsError,
        zio.aws.transcribe.model.CreateVocabularyResponse.ReadOnly
      ]
  object CreateMedicalVocabulary
      extends Effect[
        CreateMedicalVocabularyRequest,
        AwsError,
        zio.aws.transcribe.model.CreateMedicalVocabularyResponse.ReadOnly
      ]
  object GetCallAnalyticsCategory
      extends Effect[
        GetCallAnalyticsCategoryRequest,
        AwsError,
        zio.aws.transcribe.model.GetCallAnalyticsCategoryResponse.ReadOnly
      ]
  object ListMedicalVocabularies
      extends Effect[
        ListMedicalVocabulariesRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.transcribe.model.ListMedicalVocabulariesResponse.ReadOnly,
          zio.aws.transcribe.model.VocabularyInfo.ReadOnly
        ]
      ]
  object ListMedicalVocabulariesPaginated
      extends Effect[
        ListMedicalVocabulariesRequest,
        AwsError,
        zio.aws.transcribe.model.ListMedicalVocabulariesResponse.ReadOnly
      ]
  object DeleteCallAnalyticsJob
      extends Effect[
        DeleteCallAnalyticsJobRequest,
        AwsError,
        zio.aws.transcribe.model.DeleteCallAnalyticsJobResponse.ReadOnly
      ]
  object GetVocabularyFilter
      extends Effect[
        GetVocabularyFilterRequest,
        AwsError,
        zio.aws.transcribe.model.GetVocabularyFilterResponse.ReadOnly
      ]
  object UpdateVocabulary
      extends Effect[
        UpdateVocabularyRequest,
        AwsError,
        zio.aws.transcribe.model.UpdateVocabularyResponse.ReadOnly
      ]
  object ListVocabularies
      extends Effect[ListVocabulariesRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.transcribe.model.ListVocabulariesResponse.ReadOnly,
        zio.aws.transcribe.model.VocabularyInfo.ReadOnly
      ]]
  object ListVocabulariesPaginated
      extends Effect[
        ListVocabulariesRequest,
        AwsError,
        zio.aws.transcribe.model.ListVocabulariesResponse.ReadOnly
      ]
  object StartCallAnalyticsJob
      extends Effect[
        StartCallAnalyticsJobRequest,
        AwsError,
        zio.aws.transcribe.model.StartCallAnalyticsJobResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.transcribe.model.UntagResourceResponse.ReadOnly
      ]
  object CreateVocabularyFilter
      extends Effect[
        CreateVocabularyFilterRequest,
        AwsError,
        zio.aws.transcribe.model.CreateVocabularyFilterResponse.ReadOnly
      ]
  object DeleteTranscriptionJob
      extends Effect[DeleteTranscriptionJobRequest, AwsError, Unit]
  object ListTranscriptionJobs
      extends Effect[
        ListTranscriptionJobsRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.transcribe.model.ListTranscriptionJobsResponse.ReadOnly,
          zio.aws.transcribe.model.TranscriptionJobSummary.ReadOnly
        ]
      ]
  object ListTranscriptionJobsPaginated
      extends Effect[
        ListTranscriptionJobsRequest,
        AwsError,
        zio.aws.transcribe.model.ListTranscriptionJobsResponse.ReadOnly
      ]
  object DescribeLanguageModel
      extends Effect[
        DescribeLanguageModelRequest,
        AwsError,
        zio.aws.transcribe.model.DescribeLanguageModelResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.transcribe.model.ListTagsForResourceResponse.ReadOnly
      ]
  object DeleteLanguageModel
      extends Effect[DeleteLanguageModelRequest, AwsError, Unit]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.transcribe.model.TagResourceResponse.ReadOnly
      ]
  object StartMedicalTranscriptionJob
      extends Effect[
        StartMedicalTranscriptionJobRequest,
        AwsError,
        zio.aws.transcribe.model.StartMedicalTranscriptionJobResponse.ReadOnly
      ]
  object ListLanguageModels
      extends Stream[
        ListLanguageModelsRequest,
        AwsError,
        zio.aws.transcribe.model.LanguageModel.ReadOnly
      ]
  object ListLanguageModelsPaginated
      extends Effect[
        ListLanguageModelsRequest,
        AwsError,
        zio.aws.transcribe.model.ListLanguageModelsResponse.ReadOnly
      ]
  object CreateCallAnalyticsCategory
      extends Effect[
        CreateCallAnalyticsCategoryRequest,
        AwsError,
        zio.aws.transcribe.model.CreateCallAnalyticsCategoryResponse.ReadOnly
      ]
  object GetVocabulary
      extends Effect[
        GetVocabularyRequest,
        AwsError,
        zio.aws.transcribe.model.GetVocabularyResponse.ReadOnly
      ]
  object GetMedicalVocabulary
      extends Effect[
        GetMedicalVocabularyRequest,
        AwsError,
        zio.aws.transcribe.model.GetMedicalVocabularyResponse.ReadOnly
      ]
  object StartTranscriptionJob
      extends Effect[
        StartTranscriptionJobRequest,
        AwsError,
        zio.aws.transcribe.model.StartTranscriptionJobResponse.ReadOnly
      ]
  object DeleteVocabularyFilter
      extends Effect[DeleteVocabularyFilterRequest, AwsError, Unit]
  object DeleteMedicalTranscriptionJob
      extends Effect[DeleteMedicalTranscriptionJobRequest, AwsError, Unit]
  object ListCallAnalyticsCategories
      extends Stream[
        ListCallAnalyticsCategoriesRequest,
        AwsError,
        zio.aws.transcribe.model.CategoryProperties.ReadOnly
      ]
  object ListCallAnalyticsCategoriesPaginated
      extends Effect[
        ListCallAnalyticsCategoriesRequest,
        AwsError,
        zio.aws.transcribe.model.ListCallAnalyticsCategoriesResponse.ReadOnly
      ]
  object GetTranscriptionJob
      extends Effect[
        GetTranscriptionJobRequest,
        AwsError,
        zio.aws.transcribe.model.GetTranscriptionJobResponse.ReadOnly
      ]
  object ListCallAnalyticsJobs
      extends Effect[
        ListCallAnalyticsJobsRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.transcribe.model.ListCallAnalyticsJobsResponse.ReadOnly,
          zio.aws.transcribe.model.CallAnalyticsJobSummary.ReadOnly
        ]
      ]
  object ListCallAnalyticsJobsPaginated
      extends Effect[
        ListCallAnalyticsJobsRequest,
        AwsError,
        zio.aws.transcribe.model.ListCallAnalyticsJobsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Transcribe] = ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Transcribe {
          val api: TranscribeAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Transcribe = this
          def listVocabularyFilters(
              request: ListVocabularyFiltersRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.transcribe.model.VocabularyFilterInfo.ReadOnly
          ] = rts.unsafeRun(proxy(ListVocabularyFilters, request))
          def listVocabularyFiltersPaginated(
              request: ListVocabularyFiltersRequest
          ): IO[
            AwsError,
            zio.aws.transcribe.model.ListVocabularyFiltersResponse.ReadOnly
          ] = proxy(ListVocabularyFiltersPaginated, request)
          def getCallAnalyticsJob(request: GetCallAnalyticsJobRequest): IO[
            AwsError,
            zio.aws.transcribe.model.GetCallAnalyticsJobResponse.ReadOnly
          ] = proxy(GetCallAnalyticsJob, request)
          def deleteMedicalVocabulary(
              request: DeleteMedicalVocabularyRequest
          ): IO[AwsError, Unit] = proxy(DeleteMedicalVocabulary, request)
          def deleteVocabulary(
              request: DeleteVocabularyRequest
          ): IO[AwsError, Unit] = proxy(DeleteVocabulary, request)
          def updateCallAnalyticsCategory(
              request: UpdateCallAnalyticsCategoryRequest
          ): IO[
            AwsError,
            zio.aws.transcribe.model.UpdateCallAnalyticsCategoryResponse.ReadOnly
          ] = proxy(UpdateCallAnalyticsCategory, request)
          def listMedicalTranscriptionJobs(
              request: ListMedicalTranscriptionJobsRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.transcribe.model.ListMedicalTranscriptionJobsResponse.ReadOnly,
            ReadOnly
          ]] = proxy(ListMedicalTranscriptionJobs, request)
          def listMedicalTranscriptionJobsPaginated(
              request: ListMedicalTranscriptionJobsRequest
          ): IO[
            AwsError,
            zio.aws.transcribe.model.ListMedicalTranscriptionJobsResponse.ReadOnly
          ] = proxy(ListMedicalTranscriptionJobsPaginated, request)
          def updateVocabularyFilter(
              request: UpdateVocabularyFilterRequest
          ): IO[
            AwsError,
            zio.aws.transcribe.model.UpdateVocabularyFilterResponse.ReadOnly
          ] = proxy(UpdateVocabularyFilter, request)
          def createLanguageModel(request: CreateLanguageModelRequest): IO[
            AwsError,
            zio.aws.transcribe.model.CreateLanguageModelResponse.ReadOnly
          ] = proxy(CreateLanguageModel, request)
          def deleteCallAnalyticsCategory(
              request: DeleteCallAnalyticsCategoryRequest
          ): IO[
            AwsError,
            zio.aws.transcribe.model.DeleteCallAnalyticsCategoryResponse.ReadOnly
          ] = proxy(DeleteCallAnalyticsCategory, request)
          def getMedicalTranscriptionJob(
              request: GetMedicalTranscriptionJobRequest
          ): IO[
            AwsError,
            zio.aws.transcribe.model.GetMedicalTranscriptionJobResponse.ReadOnly
          ] = proxy(GetMedicalTranscriptionJob, request)
          def updateMedicalVocabulary(
              request: UpdateMedicalVocabularyRequest
          ): IO[
            AwsError,
            zio.aws.transcribe.model.UpdateMedicalVocabularyResponse.ReadOnly
          ] = proxy(UpdateMedicalVocabulary, request)
          def createVocabulary(request: CreateVocabularyRequest): IO[
            AwsError,
            zio.aws.transcribe.model.CreateVocabularyResponse.ReadOnly
          ] = proxy(CreateVocabulary, request)
          def createMedicalVocabulary(
              request: CreateMedicalVocabularyRequest
          ): IO[
            AwsError,
            zio.aws.transcribe.model.CreateMedicalVocabularyResponse.ReadOnly
          ] = proxy(CreateMedicalVocabulary, request)
          def getCallAnalyticsCategory(
              request: GetCallAnalyticsCategoryRequest
          ): IO[
            AwsError,
            zio.aws.transcribe.model.GetCallAnalyticsCategoryResponse.ReadOnly
          ] = proxy(GetCallAnalyticsCategory, request)
          def listMedicalVocabularies(
              request: ListMedicalVocabulariesRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.transcribe.model.ListMedicalVocabulariesResponse.ReadOnly,
            zio.aws.transcribe.model.VocabularyInfo.ReadOnly
          ]] = proxy(ListMedicalVocabularies, request)
          def listMedicalVocabulariesPaginated(
              request: ListMedicalVocabulariesRequest
          ): IO[
            AwsError,
            zio.aws.transcribe.model.ListMedicalVocabulariesResponse.ReadOnly
          ] = proxy(ListMedicalVocabulariesPaginated, request)
          def deleteCallAnalyticsJob(
              request: DeleteCallAnalyticsJobRequest
          ): IO[
            AwsError,
            zio.aws.transcribe.model.DeleteCallAnalyticsJobResponse.ReadOnly
          ] = proxy(DeleteCallAnalyticsJob, request)
          def getVocabularyFilter(request: GetVocabularyFilterRequest): IO[
            AwsError,
            zio.aws.transcribe.model.GetVocabularyFilterResponse.ReadOnly
          ] = proxy(GetVocabularyFilter, request)
          def updateVocabulary(request: UpdateVocabularyRequest): IO[
            AwsError,
            zio.aws.transcribe.model.UpdateVocabularyResponse.ReadOnly
          ] = proxy(UpdateVocabulary, request)
          def listVocabularies(
              request: ListVocabulariesRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.transcribe.model.ListVocabulariesResponse.ReadOnly,
            zio.aws.transcribe.model.VocabularyInfo.ReadOnly
          ]] = proxy(ListVocabularies, request)
          def listVocabulariesPaginated(request: ListVocabulariesRequest): IO[
            AwsError,
            zio.aws.transcribe.model.ListVocabulariesResponse.ReadOnly
          ] = proxy(ListVocabulariesPaginated, request)
          def startCallAnalyticsJob(request: StartCallAnalyticsJobRequest): IO[
            AwsError,
            zio.aws.transcribe.model.StartCallAnalyticsJobResponse.ReadOnly
          ] = proxy(StartCallAnalyticsJob, request)
          def untagResource(request: UntagResourceRequest): IO[
            AwsError,
            zio.aws.transcribe.model.UntagResourceResponse.ReadOnly
          ] = proxy(UntagResource, request)
          def createVocabularyFilter(
              request: CreateVocabularyFilterRequest
          ): IO[
            AwsError,
            zio.aws.transcribe.model.CreateVocabularyFilterResponse.ReadOnly
          ] = proxy(CreateVocabularyFilter, request)
          def deleteTranscriptionJob(
              request: DeleteTranscriptionJobRequest
          ): IO[AwsError, Unit] = proxy(DeleteTranscriptionJob, request)
          def listTranscriptionJobs(
              request: ListTranscriptionJobsRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.transcribe.model.ListTranscriptionJobsResponse.ReadOnly,
            zio.aws.transcribe.model.TranscriptionJobSummary.ReadOnly
          ]] = proxy(ListTranscriptionJobs, request)
          def listTranscriptionJobsPaginated(
              request: ListTranscriptionJobsRequest
          ): IO[
            AwsError,
            zio.aws.transcribe.model.ListTranscriptionJobsResponse.ReadOnly
          ] = proxy(ListTranscriptionJobsPaginated, request)
          def describeLanguageModel(request: DescribeLanguageModelRequest): IO[
            AwsError,
            zio.aws.transcribe.model.DescribeLanguageModelResponse.ReadOnly
          ] = proxy(DescribeLanguageModel, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.transcribe.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def deleteLanguageModel(
              request: DeleteLanguageModelRequest
          ): IO[AwsError, Unit] = proxy(DeleteLanguageModel, request)
          def tagResource(request: TagResourceRequest): IO[
            AwsError,
            zio.aws.transcribe.model.TagResourceResponse.ReadOnly
          ] = proxy(TagResource, request)
          def startMedicalTranscriptionJob(
              request: StartMedicalTranscriptionJobRequest
          ): IO[
            AwsError,
            zio.aws.transcribe.model.StartMedicalTranscriptionJobResponse.ReadOnly
          ] = proxy(StartMedicalTranscriptionJob, request)
          def listLanguageModels(request: ListLanguageModelsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.transcribe.model.LanguageModel.ReadOnly
          ] = rts.unsafeRun(proxy(ListLanguageModels, request))
          def listLanguageModelsPaginated(
              request: ListLanguageModelsRequest
          ): IO[
            AwsError,
            zio.aws.transcribe.model.ListLanguageModelsResponse.ReadOnly
          ] = proxy(ListLanguageModelsPaginated, request)
          def createCallAnalyticsCategory(
              request: CreateCallAnalyticsCategoryRequest
          ): IO[
            AwsError,
            zio.aws.transcribe.model.CreateCallAnalyticsCategoryResponse.ReadOnly
          ] = proxy(CreateCallAnalyticsCategory, request)
          def getVocabulary(request: GetVocabularyRequest): IO[
            AwsError,
            zio.aws.transcribe.model.GetVocabularyResponse.ReadOnly
          ] = proxy(GetVocabulary, request)
          def getMedicalVocabulary(request: GetMedicalVocabularyRequest): IO[
            AwsError,
            zio.aws.transcribe.model.GetMedicalVocabularyResponse.ReadOnly
          ] = proxy(GetMedicalVocabulary, request)
          def startTranscriptionJob(request: StartTranscriptionJobRequest): IO[
            AwsError,
            zio.aws.transcribe.model.StartTranscriptionJobResponse.ReadOnly
          ] = proxy(StartTranscriptionJob, request)
          def deleteVocabularyFilter(
              request: DeleteVocabularyFilterRequest
          ): IO[AwsError, Unit] = proxy(DeleteVocabularyFilter, request)
          def deleteMedicalTranscriptionJob(
              request: DeleteMedicalTranscriptionJobRequest
          ): IO[AwsError, Unit] = proxy(DeleteMedicalTranscriptionJob, request)
          def listCallAnalyticsCategories(
              request: ListCallAnalyticsCategoriesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.transcribe.model.CategoryProperties.ReadOnly
          ] = rts.unsafeRun(proxy(ListCallAnalyticsCategories, request))
          def listCallAnalyticsCategoriesPaginated(
              request: ListCallAnalyticsCategoriesRequest
          ): IO[
            AwsError,
            zio.aws.transcribe.model.ListCallAnalyticsCategoriesResponse.ReadOnly
          ] = proxy(ListCallAnalyticsCategoriesPaginated, request)
          def getTranscriptionJob(request: GetTranscriptionJobRequest): IO[
            AwsError,
            zio.aws.transcribe.model.GetTranscriptionJobResponse.ReadOnly
          ] = proxy(GetTranscriptionJob, request)
          def listCallAnalyticsJobs(
              request: ListCallAnalyticsJobsRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.transcribe.model.ListCallAnalyticsJobsResponse.ReadOnly,
            zio.aws.transcribe.model.CallAnalyticsJobSummary.ReadOnly
          ]] = proxy(ListCallAnalyticsJobs, request)
          def listCallAnalyticsJobsPaginated(
              request: ListCallAnalyticsJobsRequest
          ): IO[
            AwsError,
            zio.aws.transcribe.model.ListCallAnalyticsJobsResponse.ReadOnly
          ] = proxy(ListCallAnalyticsJobsPaginated, request)
        }
      }
    }
    .toLayer
}
