package zio.aws.transcribe.model
import java.lang.Integer
import zio.ZIO
import zio.aws.transcribe.model.primitives.{
  OutputBucketName,
  MediaSampleRateHertz,
  OutputKey,
  NonEmptyString,
  TranscriptionJobName,
  KMSKeyId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StartMedicalTranscriptionJobRequest(
    medicalTranscriptionJobName: TranscriptionJobName,
    languageCode: zio.aws.transcribe.model.LanguageCode,
    mediaSampleRateHertz: Option[MediaSampleRateHertz] = None,
    mediaFormat: Option[zio.aws.transcribe.model.MediaFormat] = None,
    media: zio.aws.transcribe.model.Media,
    outputBucketName: OutputBucketName,
    outputKey: Option[OutputKey] = None,
    outputEncryptionKMSKeyId: Option[KMSKeyId] = None,
    kmsEncryptionContext: Option[Map[NonEmptyString, NonEmptyString]] = None,
    settings: Option[zio.aws.transcribe.model.MedicalTranscriptionSetting] =
      None,
    contentIdentificationType: Option[
      zio.aws.transcribe.model.MedicalContentIdentificationType
    ] = None,
    specialty: zio.aws.transcribe.model.Specialty,
    `type`: zio.aws.transcribe.model.Type,
    tags: Option[Iterable[zio.aws.transcribe.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.StartMedicalTranscriptionJobRequest = {
    import StartMedicalTranscriptionJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.StartMedicalTranscriptionJobRequest
      .builder()
      .medicalTranscriptionJobName(
        TranscriptionJobName.unwrap(
          medicalTranscriptionJobName
        ): java.lang.String
      )
      .languageCode(languageCode.unwrap)
      .optionallyWith(
        mediaSampleRateHertz.map(value =>
          MediaSampleRateHertz.unwrap(value): Integer
        )
      )(_.mediaSampleRateHertz)
      .optionallyWith(mediaFormat.map(value => value.unwrap))(_.mediaFormat)
      .media(media.buildAwsValue())
      .outputBucketName(
        OutputBucketName.unwrap(outputBucketName): java.lang.String
      )
      .optionallyWith(
        outputKey.map(value => OutputKey.unwrap(value): java.lang.String)
      )(_.outputKey)
      .optionallyWith(
        outputEncryptionKMSKeyId.map(value =>
          KMSKeyId.unwrap(value): java.lang.String
        )
      )(_.outputEncryptionKMSKeyId)
      .optionallyWith(
        kmsEncryptionContext.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.kmsEncryptionContext)
      .optionallyWith(settings.map(value => value.buildAwsValue()))(_.settings)
      .optionallyWith(contentIdentificationType.map(value => value.unwrap))(
        _.contentIdentificationType
      )
      .specialty(specialty.unwrap)
      .`type`(`type`.unwrap)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.StartMedicalTranscriptionJobRequest.ReadOnly =
    zio.aws.transcribe.model.StartMedicalTranscriptionJobRequest
      .wrap(buildAwsValue())
}
object StartMedicalTranscriptionJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.StartMedicalTranscriptionJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.transcribe.model.StartMedicalTranscriptionJobRequest =
      zio.aws.transcribe.model.StartMedicalTranscriptionJobRequest(
        medicalTranscriptionJobName,
        languageCode,
        mediaSampleRateHertz.map(value => value),
        mediaFormat.map(value => value),
        media.asEditable,
        outputBucketName,
        outputKey.map(value => value),
        outputEncryptionKMSKeyId.map(value => value),
        kmsEncryptionContext.map(value => value),
        settings.map(value => value.asEditable),
        contentIdentificationType.map(value => value),
        specialty,
        `type`,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def medicalTranscriptionJobName: TranscriptionJobName
    def languageCode: zio.aws.transcribe.model.LanguageCode
    def mediaSampleRateHertz: Option[MediaSampleRateHertz]
    def mediaFormat: Option[zio.aws.transcribe.model.MediaFormat]
    def media: zio.aws.transcribe.model.Media.ReadOnly
    def outputBucketName: OutputBucketName
    def outputKey: Option[OutputKey]
    def outputEncryptionKMSKeyId: Option[KMSKeyId]
    def kmsEncryptionContext: Option[Map[NonEmptyString, NonEmptyString]]
    def settings
        : Option[zio.aws.transcribe.model.MedicalTranscriptionSetting.ReadOnly]
    def contentIdentificationType
        : Option[zio.aws.transcribe.model.MedicalContentIdentificationType]
    def specialty: zio.aws.transcribe.model.Specialty
    def `type`: zio.aws.transcribe.model.Type
    def tags: Option[List[zio.aws.transcribe.model.Tag.ReadOnly]]
    def getMedicalTranscriptionJobName
        : ZIO[Any, Nothing, TranscriptionJobName] =
      ZIO.succeed(medicalTranscriptionJobName)
    def getLanguageCode
        : ZIO[Any, Nothing, zio.aws.transcribe.model.LanguageCode] =
      ZIO.succeed(languageCode)
    def getMediaSampleRateHertz: ZIO[Any, AwsError, MediaSampleRateHertz] =
      AwsError.unwrapOptionField("mediaSampleRateHertz", mediaSampleRateHertz)
    def getMediaFormat
        : ZIO[Any, AwsError, zio.aws.transcribe.model.MediaFormat] =
      AwsError.unwrapOptionField("mediaFormat", mediaFormat)
    def getMedia: ZIO[Any, Nothing, zio.aws.transcribe.model.Media.ReadOnly] =
      ZIO.succeed(media)
    def getOutputBucketName: ZIO[Any, Nothing, OutputBucketName] =
      ZIO.succeed(outputBucketName)
    def getOutputKey: ZIO[Any, AwsError, OutputKey] =
      AwsError.unwrapOptionField("outputKey", outputKey)
    def getOutputEncryptionKMSKeyId: ZIO[Any, AwsError, KMSKeyId] = AwsError
      .unwrapOptionField("outputEncryptionKMSKeyId", outputEncryptionKMSKeyId)
    def getKmsEncryptionContext
        : ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("kmsEncryptionContext", kmsEncryptionContext)
    def getSettings: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.MedicalTranscriptionSetting.ReadOnly
    ] = AwsError.unwrapOptionField("settings", settings)
    def getContentIdentificationType: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.MedicalContentIdentificationType
    ] = AwsError.unwrapOptionField(
      "contentIdentificationType",
      contentIdentificationType
    )
    def getSpecialty: ZIO[Any, Nothing, zio.aws.transcribe.model.Specialty] =
      ZIO.succeed(specialty)
    def getType: ZIO[Any, Nothing, zio.aws.transcribe.model.Type] =
      ZIO.succeed(`type`)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.transcribe.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.StartMedicalTranscriptionJobRequest
  ) extends zio.aws.transcribe.model.StartMedicalTranscriptionJobRequest.ReadOnly {
    override val medicalTranscriptionJobName: TranscriptionJobName =
      zio.aws.transcribe.model.primitives
        .TranscriptionJobName(impl.medicalTranscriptionJobName())
    override val languageCode: zio.aws.transcribe.model.LanguageCode =
      zio.aws.transcribe.model.LanguageCode.wrap(impl.languageCode())
    override val mediaSampleRateHertz: Option[MediaSampleRateHertz] = scala
      .Option(impl.mediaSampleRateHertz())
      .map(value =>
        zio.aws.transcribe.model.primitives.MediaSampleRateHertz(value)
      )
    override val mediaFormat: Option[zio.aws.transcribe.model.MediaFormat] =
      scala
        .Option(impl.mediaFormat())
        .map(value => zio.aws.transcribe.model.MediaFormat.wrap(value))
    override val media: zio.aws.transcribe.model.Media.ReadOnly =
      zio.aws.transcribe.model.Media.wrap(impl.media())
    override val outputBucketName: OutputBucketName =
      zio.aws.transcribe.model.primitives
        .OutputBucketName(impl.outputBucketName())
    override val outputKey: Option[OutputKey] = scala
      .Option(impl.outputKey())
      .map(value => zio.aws.transcribe.model.primitives.OutputKey(value))
    override val outputEncryptionKMSKeyId: Option[KMSKeyId] = scala
      .Option(impl.outputEncryptionKMSKeyId())
      .map(value => zio.aws.transcribe.model.primitives.KMSKeyId(value))
    override val kmsEncryptionContext
        : Option[Map[NonEmptyString, NonEmptyString]] = scala
      .Option(impl.kmsEncryptionContext())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.transcribe.model.primitives.NonEmptyString(
              key
            ) -> zio.aws.transcribe.model.primitives.NonEmptyString(value)
          })
          .toMap
      )
    override val settings: Option[
      zio.aws.transcribe.model.MedicalTranscriptionSetting.ReadOnly
    ] = scala
      .Option(impl.settings())
      .map(value =>
        zio.aws.transcribe.model.MedicalTranscriptionSetting.wrap(value)
      )
    override val contentIdentificationType
        : Option[zio.aws.transcribe.model.MedicalContentIdentificationType] =
      scala
        .Option(impl.contentIdentificationType())
        .map(value =>
          zio.aws.transcribe.model.MedicalContentIdentificationType.wrap(value)
        )
    override val specialty: zio.aws.transcribe.model.Specialty =
      zio.aws.transcribe.model.Specialty.wrap(impl.specialty())
    override val `type`: zio.aws.transcribe.model.Type =
      zio.aws.transcribe.model.Type.wrap(impl.`type`())
    override val tags: Option[List[zio.aws.transcribe.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transcribe.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.StartMedicalTranscriptionJobRequest
  ): zio.aws.transcribe.model.StartMedicalTranscriptionJobRequest.ReadOnly =
    new Wrapper(impl)
}
