package zio.aws.transcribe.model
import java.lang.Integer
import zio.ZIO
import zio.aws.transcribe.model.primitives.Percentage
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RelativeTimeRange(
    startPercentage: Option[Percentage] = None,
    endPercentage: Option[Percentage] = None,
    first: Option[Percentage] = None,
    last: Option[Percentage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.RelativeTimeRange = {
    import RelativeTimeRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.RelativeTimeRange
      .builder()
      .optionallyWith(
        startPercentage.map(value => Percentage.unwrap(value): Integer)
      )(_.startPercentage)
      .optionallyWith(
        endPercentage.map(value => Percentage.unwrap(value): Integer)
      )(_.endPercentage)
      .optionallyWith(first.map(value => Percentage.unwrap(value): Integer))(
        _.first
      )
      .optionallyWith(last.map(value => Percentage.unwrap(value): Integer))(
        _.last
      )
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.RelativeTimeRange.ReadOnly =
    zio.aws.transcribe.model.RelativeTimeRange.wrap(buildAwsValue())
}
object RelativeTimeRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.RelativeTimeRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.RelativeTimeRange =
      zio.aws.transcribe.model.RelativeTimeRange(
        startPercentage.map(value => value),
        endPercentage.map(value => value),
        first.map(value => value),
        last.map(value => value)
      )
    def startPercentage: Option[Percentage]
    def endPercentage: Option[Percentage]
    def first: Option[Percentage]
    def last: Option[Percentage]
    def getStartPercentage: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("startPercentage", startPercentage)
    def getEndPercentage: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("endPercentage", endPercentage)
    def getFirst: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("first", first)
    def getLast: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("last", last)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.RelativeTimeRange
  ) extends zio.aws.transcribe.model.RelativeTimeRange.ReadOnly {
    override val startPercentage: Option[Percentage] = scala
      .Option(impl.startPercentage())
      .map(value => zio.aws.transcribe.model.primitives.Percentage(value))
    override val endPercentage: Option[Percentage] = scala
      .Option(impl.endPercentage())
      .map(value => zio.aws.transcribe.model.primitives.Percentage(value))
    override val first: Option[Percentage] = scala
      .Option(impl.first())
      .map(value => zio.aws.transcribe.model.primitives.Percentage(value))
    override val last: Option[Percentage] = scala
      .Option(impl.last())
      .map(value => zio.aws.transcribe.model.primitives.Percentage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.RelativeTimeRange
  ): zio.aws.transcribe.model.RelativeTimeRange.ReadOnly = new Wrapper(impl)
}
