package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListLanguageModelsResponse(
    nextToken: Option[NextToken] = None,
    models: Option[Iterable[zio.aws.transcribe.model.LanguageModel]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.ListLanguageModelsResponse = {
    import ListLanguageModelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.ListLanguageModelsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        models.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.models)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.ListLanguageModelsResponse.ReadOnly =
    zio.aws.transcribe.model.ListLanguageModelsResponse.wrap(buildAwsValue())
}
object ListLanguageModelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.ListLanguageModelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.ListLanguageModelsResponse =
      zio.aws.transcribe.model.ListLanguageModelsResponse(
        nextToken.map(value => value),
        models.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def models: Option[List[zio.aws.transcribe.model.LanguageModel.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getModels: ZIO[Any, AwsError, List[
      zio.aws.transcribe.model.LanguageModel.ReadOnly
    ]] = AwsError.unwrapOptionField("models", models)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.ListLanguageModelsResponse
  ) extends zio.aws.transcribe.model.ListLanguageModelsResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.transcribe.model.primitives.NextToken(value))
    override val models
        : Option[List[zio.aws.transcribe.model.LanguageModel.ReadOnly]] = scala
      .Option(impl.models())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transcribe.model.LanguageModel.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.ListLanguageModelsResponse
  ): zio.aws.transcribe.model.ListLanguageModelsResponse.ReadOnly = new Wrapper(
    impl
  )
}
