package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.{
  IdentifiedLanguageScore,
  FailureReason,
  DateTime,
  TranscriptionJobName
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class TranscriptionJobSummary(
    transcriptionJobName: Option[TranscriptionJobName] = None,
    creationTime: Option[DateTime] = None,
    startTime: Option[DateTime] = None,
    completionTime: Option[DateTime] = None,
    languageCode: Option[zio.aws.transcribe.model.LanguageCode] = None,
    transcriptionJobStatus: Option[
      zio.aws.transcribe.model.TranscriptionJobStatus
    ] = None,
    failureReason: Option[FailureReason] = None,
    outputLocationType: Option[zio.aws.transcribe.model.OutputLocationType] =
      None,
    contentRedaction: Option[zio.aws.transcribe.model.ContentRedaction] = None,
    modelSettings: Option[zio.aws.transcribe.model.ModelSettings] = None,
    identifyLanguage: Option[Boolean] = None,
    identifiedLanguageScore: Option[IdentifiedLanguageScore] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.TranscriptionJobSummary = {
    import TranscriptionJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.TranscriptionJobSummary
      .builder()
      .optionallyWith(
        transcriptionJobName.map(value =>
          TranscriptionJobName.unwrap(value): java.lang.String
        )
      )(_.transcriptionJobName)
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(startTime.map(value => DateTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(
        completionTime.map(value => DateTime.unwrap(value): Instant)
      )(_.completionTime)
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(transcriptionJobStatus.map(value => value.unwrap))(
        _.transcriptionJobStatus
      )
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(outputLocationType.map(value => value.unwrap))(
        _.outputLocationType
      )
      .optionallyWith(contentRedaction.map(value => value.buildAwsValue()))(
        _.contentRedaction
      )
      .optionallyWith(modelSettings.map(value => value.buildAwsValue()))(
        _.modelSettings
      )
      .optionallyWith(identifyLanguage.map(value => value: java.lang.Boolean))(
        _.identifyLanguage
      )
      .optionallyWith(
        identifiedLanguageScore.map(value =>
          IdentifiedLanguageScore.unwrap(value): java.lang.Float
        )
      )(_.identifiedLanguageScore)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.TranscriptionJobSummary.ReadOnly =
    zio.aws.transcribe.model.TranscriptionJobSummary.wrap(buildAwsValue())
}
object TranscriptionJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.TranscriptionJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.TranscriptionJobSummary =
      zio.aws.transcribe.model.TranscriptionJobSummary(
        transcriptionJobName.map(value => value),
        creationTime.map(value => value),
        startTime.map(value => value),
        completionTime.map(value => value),
        languageCode.map(value => value),
        transcriptionJobStatus.map(value => value),
        failureReason.map(value => value),
        outputLocationType.map(value => value),
        contentRedaction.map(value => value.asEditable),
        modelSettings.map(value => value.asEditable),
        identifyLanguage.map(value => value),
        identifiedLanguageScore.map(value => value)
      )
    def transcriptionJobName: Option[TranscriptionJobName]
    def creationTime: Option[DateTime]
    def startTime: Option[DateTime]
    def completionTime: Option[DateTime]
    def languageCode: Option[zio.aws.transcribe.model.LanguageCode]
    def transcriptionJobStatus
        : Option[zio.aws.transcribe.model.TranscriptionJobStatus]
    def failureReason: Option[FailureReason]
    def outputLocationType: Option[zio.aws.transcribe.model.OutputLocationType]
    def contentRedaction
        : Option[zio.aws.transcribe.model.ContentRedaction.ReadOnly]
    def modelSettings: Option[zio.aws.transcribe.model.ModelSettings.ReadOnly]
    def identifyLanguage: Option[Boolean]
    def identifiedLanguageScore: Option[IdentifiedLanguageScore]
    def getTranscriptionJobName: ZIO[Any, AwsError, TranscriptionJobName] =
      AwsError.unwrapOptionField("transcriptionJobName", transcriptionJobName)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getCompletionTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("completionTime", completionTime)
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.transcribe.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getTranscriptionJobStatus
        : ZIO[Any, AwsError, zio.aws.transcribe.model.TranscriptionJobStatus] =
      AwsError.unwrapOptionField(
        "transcriptionJobStatus",
        transcriptionJobStatus
      )
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getOutputLocationType
        : ZIO[Any, AwsError, zio.aws.transcribe.model.OutputLocationType] =
      AwsError.unwrapOptionField("outputLocationType", outputLocationType)
    def getContentRedaction: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.ContentRedaction.ReadOnly
    ] = AwsError.unwrapOptionField("contentRedaction", contentRedaction)
    def getModelSettings
        : ZIO[Any, AwsError, zio.aws.transcribe.model.ModelSettings.ReadOnly] =
      AwsError.unwrapOptionField("modelSettings", modelSettings)
    def getIdentifyLanguage: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("identifyLanguage", identifyLanguage)
    def getIdentifiedLanguageScore
        : ZIO[Any, AwsError, IdentifiedLanguageScore] = AwsError
      .unwrapOptionField("identifiedLanguageScore", identifiedLanguageScore)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.TranscriptionJobSummary
  ) extends zio.aws.transcribe.model.TranscriptionJobSummary.ReadOnly {
    override val transcriptionJobName: Option[TranscriptionJobName] = scala
      .Option(impl.transcriptionJobName())
      .map(value =>
        zio.aws.transcribe.model.primitives.TranscriptionJobName(value)
      )
    override val creationTime: Option[DateTime] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val startTime: Option[DateTime] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val completionTime: Option[DateTime] = scala
      .Option(impl.completionTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val languageCode: Option[zio.aws.transcribe.model.LanguageCode] =
      scala
        .Option(impl.languageCode())
        .map(value => zio.aws.transcribe.model.LanguageCode.wrap(value))
    override val transcriptionJobStatus
        : Option[zio.aws.transcribe.model.TranscriptionJobStatus] = scala
      .Option(impl.transcriptionJobStatus())
      .map(value => zio.aws.transcribe.model.TranscriptionJobStatus.wrap(value))
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.transcribe.model.primitives.FailureReason(value))
    override val outputLocationType
        : Option[zio.aws.transcribe.model.OutputLocationType] = scala
      .Option(impl.outputLocationType())
      .map(value => zio.aws.transcribe.model.OutputLocationType.wrap(value))
    override val contentRedaction
        : Option[zio.aws.transcribe.model.ContentRedaction.ReadOnly] = scala
      .Option(impl.contentRedaction())
      .map(value => zio.aws.transcribe.model.ContentRedaction.wrap(value))
    override val modelSettings
        : Option[zio.aws.transcribe.model.ModelSettings.ReadOnly] = scala
      .Option(impl.modelSettings())
      .map(value => zio.aws.transcribe.model.ModelSettings.wrap(value))
    override val identifyLanguage: Option[Boolean] =
      scala.Option(impl.identifyLanguage()).map(value => value: Boolean)
    override val identifiedLanguageScore: Option[IdentifiedLanguageScore] =
      scala
        .Option(impl.identifiedLanguageScore())
        .map(value =>
          zio.aws.transcribe.model.primitives.IdentifiedLanguageScore(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.TranscriptionJobSummary
  ): zio.aws.transcribe.model.TranscriptionJobSummary.ReadOnly = new Wrapper(
    impl
  )
}
