package zio.aws.transcribe.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.transcribe.model.primitives.{
  IdentifiedLanguageScore,
  FailureReason,
  MediaSampleRateHertz,
  DateTime,
  TranscriptionJobName
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class TranscriptionJob(
    transcriptionJobName: Option[TranscriptionJobName] = None,
    transcriptionJobStatus: Option[
      zio.aws.transcribe.model.TranscriptionJobStatus
    ] = None,
    languageCode: Option[zio.aws.transcribe.model.LanguageCode] = None,
    mediaSampleRateHertz: Option[MediaSampleRateHertz] = None,
    mediaFormat: Option[zio.aws.transcribe.model.MediaFormat] = None,
    media: Option[zio.aws.transcribe.model.Media] = None,
    transcript: Option[zio.aws.transcribe.model.Transcript] = None,
    startTime: Option[DateTime] = None,
    creationTime: Option[DateTime] = None,
    completionTime: Option[DateTime] = None,
    failureReason: Option[FailureReason] = None,
    settings: Option[zio.aws.transcribe.model.Settings] = None,
    modelSettings: Option[zio.aws.transcribe.model.ModelSettings] = None,
    jobExecutionSettings: Option[
      zio.aws.transcribe.model.JobExecutionSettings
    ] = None,
    contentRedaction: Option[zio.aws.transcribe.model.ContentRedaction] = None,
    identifyLanguage: Option[Boolean] = None,
    languageOptions: Option[Iterable[zio.aws.transcribe.model.LanguageCode]] =
      None,
    identifiedLanguageScore: Option[IdentifiedLanguageScore] = None,
    tags: Option[Iterable[zio.aws.transcribe.model.Tag]] = None,
    subtitles: Option[zio.aws.transcribe.model.SubtitlesOutput] = None,
    languageIdSettings: Option[Map[
      zio.aws.transcribe.model.LanguageCode,
      zio.aws.transcribe.model.LanguageIdSettings
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.TranscriptionJob = {
    import TranscriptionJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.TranscriptionJob
      .builder()
      .optionallyWith(
        transcriptionJobName.map(value =>
          TranscriptionJobName.unwrap(value): java.lang.String
        )
      )(_.transcriptionJobName)
      .optionallyWith(transcriptionJobStatus.map(value => value.unwrap))(
        _.transcriptionJobStatus
      )
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(
        mediaSampleRateHertz.map(value =>
          MediaSampleRateHertz.unwrap(value): Integer
        )
      )(_.mediaSampleRateHertz)
      .optionallyWith(mediaFormat.map(value => value.unwrap))(_.mediaFormat)
      .optionallyWith(media.map(value => value.buildAwsValue()))(_.media)
      .optionallyWith(transcript.map(value => value.buildAwsValue()))(
        _.transcript
      )
      .optionallyWith(startTime.map(value => DateTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        completionTime.map(value => DateTime.unwrap(value): Instant)
      )(_.completionTime)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(settings.map(value => value.buildAwsValue()))(_.settings)
      .optionallyWith(modelSettings.map(value => value.buildAwsValue()))(
        _.modelSettings
      )
      .optionallyWith(jobExecutionSettings.map(value => value.buildAwsValue()))(
        _.jobExecutionSettings
      )
      .optionallyWith(contentRedaction.map(value => value.buildAwsValue()))(
        _.contentRedaction
      )
      .optionallyWith(identifyLanguage.map(value => value: java.lang.Boolean))(
        _.identifyLanguage
      )
      .optionallyWith(
        languageOptions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.languageOptionsWithStrings)
      .optionallyWith(
        identifiedLanguageScore.map(value =>
          IdentifiedLanguageScore.unwrap(value): java.lang.Float
        )
      )(_.identifiedLanguageScore)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(subtitles.map(value => value.buildAwsValue()))(
        _.subtitles
      )
      .optionallyWith(
        languageIdSettings.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.languageIdSettingsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.TranscriptionJob.ReadOnly =
    zio.aws.transcribe.model.TranscriptionJob.wrap(buildAwsValue())
}
object TranscriptionJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.TranscriptionJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.TranscriptionJob =
      zio.aws.transcribe.model.TranscriptionJob(
        transcriptionJobName.map(value => value),
        transcriptionJobStatus.map(value => value),
        languageCode.map(value => value),
        mediaSampleRateHertz.map(value => value),
        mediaFormat.map(value => value),
        media.map(value => value.asEditable),
        transcript.map(value => value.asEditable),
        startTime.map(value => value),
        creationTime.map(value => value),
        completionTime.map(value => value),
        failureReason.map(value => value),
        settings.map(value => value.asEditable),
        modelSettings.map(value => value.asEditable),
        jobExecutionSettings.map(value => value.asEditable),
        contentRedaction.map(value => value.asEditable),
        identifyLanguage.map(value => value),
        languageOptions.map(value => value),
        identifiedLanguageScore.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        subtitles.map(value => value.asEditable),
        languageIdSettings.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def transcriptionJobName: Option[TranscriptionJobName]
    def transcriptionJobStatus
        : Option[zio.aws.transcribe.model.TranscriptionJobStatus]
    def languageCode: Option[zio.aws.transcribe.model.LanguageCode]
    def mediaSampleRateHertz: Option[MediaSampleRateHertz]
    def mediaFormat: Option[zio.aws.transcribe.model.MediaFormat]
    def media: Option[zio.aws.transcribe.model.Media.ReadOnly]
    def transcript: Option[zio.aws.transcribe.model.Transcript.ReadOnly]
    def startTime: Option[DateTime]
    def creationTime: Option[DateTime]
    def completionTime: Option[DateTime]
    def failureReason: Option[FailureReason]
    def settings: Option[zio.aws.transcribe.model.Settings.ReadOnly]
    def modelSettings: Option[zio.aws.transcribe.model.ModelSettings.ReadOnly]
    def jobExecutionSettings
        : Option[zio.aws.transcribe.model.JobExecutionSettings.ReadOnly]
    def contentRedaction
        : Option[zio.aws.transcribe.model.ContentRedaction.ReadOnly]
    def identifyLanguage: Option[Boolean]
    def languageOptions: Option[List[zio.aws.transcribe.model.LanguageCode]]
    def identifiedLanguageScore: Option[IdentifiedLanguageScore]
    def tags: Option[List[zio.aws.transcribe.model.Tag.ReadOnly]]
    def subtitles: Option[zio.aws.transcribe.model.SubtitlesOutput.ReadOnly]
    def languageIdSettings: Option[Map[
      zio.aws.transcribe.model.LanguageCode,
      zio.aws.transcribe.model.LanguageIdSettings.ReadOnly
    ]]
    def getTranscriptionJobName: ZIO[Any, AwsError, TranscriptionJobName] =
      AwsError.unwrapOptionField("transcriptionJobName", transcriptionJobName)
    def getTranscriptionJobStatus
        : ZIO[Any, AwsError, zio.aws.transcribe.model.TranscriptionJobStatus] =
      AwsError.unwrapOptionField(
        "transcriptionJobStatus",
        transcriptionJobStatus
      )
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.transcribe.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getMediaSampleRateHertz: ZIO[Any, AwsError, MediaSampleRateHertz] =
      AwsError.unwrapOptionField("mediaSampleRateHertz", mediaSampleRateHertz)
    def getMediaFormat
        : ZIO[Any, AwsError, zio.aws.transcribe.model.MediaFormat] =
      AwsError.unwrapOptionField("mediaFormat", mediaFormat)
    def getMedia: ZIO[Any, AwsError, zio.aws.transcribe.model.Media.ReadOnly] =
      AwsError.unwrapOptionField("media", media)
    def getTranscript
        : ZIO[Any, AwsError, zio.aws.transcribe.model.Transcript.ReadOnly] =
      AwsError.unwrapOptionField("transcript", transcript)
    def getStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getCompletionTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("completionTime", completionTime)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getSettings
        : ZIO[Any, AwsError, zio.aws.transcribe.model.Settings.ReadOnly] =
      AwsError.unwrapOptionField("settings", settings)
    def getModelSettings
        : ZIO[Any, AwsError, zio.aws.transcribe.model.ModelSettings.ReadOnly] =
      AwsError.unwrapOptionField("modelSettings", modelSettings)
    def getJobExecutionSettings: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.JobExecutionSettings.ReadOnly
    ] = AwsError.unwrapOptionField("jobExecutionSettings", jobExecutionSettings)
    def getContentRedaction: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.ContentRedaction.ReadOnly
    ] = AwsError.unwrapOptionField("contentRedaction", contentRedaction)
    def getIdentifyLanguage: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("identifyLanguage", identifyLanguage)
    def getLanguageOptions
        : ZIO[Any, AwsError, List[zio.aws.transcribe.model.LanguageCode]] =
      AwsError.unwrapOptionField("languageOptions", languageOptions)
    def getIdentifiedLanguageScore
        : ZIO[Any, AwsError, IdentifiedLanguageScore] = AwsError
      .unwrapOptionField("identifiedLanguageScore", identifiedLanguageScore)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.transcribe.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSubtitles: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.SubtitlesOutput.ReadOnly
    ] = AwsError.unwrapOptionField("subtitles", subtitles)
    def getLanguageIdSettings: ZIO[Any, AwsError, Map[
      zio.aws.transcribe.model.LanguageCode,
      zio.aws.transcribe.model.LanguageIdSettings.ReadOnly
    ]] = AwsError.unwrapOptionField("languageIdSettings", languageIdSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.TranscriptionJob
  ) extends zio.aws.transcribe.model.TranscriptionJob.ReadOnly {
    override val transcriptionJobName: Option[TranscriptionJobName] = scala
      .Option(impl.transcriptionJobName())
      .map(value =>
        zio.aws.transcribe.model.primitives.TranscriptionJobName(value)
      )
    override val transcriptionJobStatus
        : Option[zio.aws.transcribe.model.TranscriptionJobStatus] = scala
      .Option(impl.transcriptionJobStatus())
      .map(value => zio.aws.transcribe.model.TranscriptionJobStatus.wrap(value))
    override val languageCode: Option[zio.aws.transcribe.model.LanguageCode] =
      scala
        .Option(impl.languageCode())
        .map(value => zio.aws.transcribe.model.LanguageCode.wrap(value))
    override val mediaSampleRateHertz: Option[MediaSampleRateHertz] = scala
      .Option(impl.mediaSampleRateHertz())
      .map(value =>
        zio.aws.transcribe.model.primitives.MediaSampleRateHertz(value)
      )
    override val mediaFormat: Option[zio.aws.transcribe.model.MediaFormat] =
      scala
        .Option(impl.mediaFormat())
        .map(value => zio.aws.transcribe.model.MediaFormat.wrap(value))
    override val media: Option[zio.aws.transcribe.model.Media.ReadOnly] = scala
      .Option(impl.media())
      .map(value => zio.aws.transcribe.model.Media.wrap(value))
    override val transcript
        : Option[zio.aws.transcribe.model.Transcript.ReadOnly] = scala
      .Option(impl.transcript())
      .map(value => zio.aws.transcribe.model.Transcript.wrap(value))
    override val startTime: Option[DateTime] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val creationTime: Option[DateTime] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val completionTime: Option[DateTime] = scala
      .Option(impl.completionTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.transcribe.model.primitives.FailureReason(value))
    override val settings: Option[zio.aws.transcribe.model.Settings.ReadOnly] =
      scala
        .Option(impl.settings())
        .map(value => zio.aws.transcribe.model.Settings.wrap(value))
    override val modelSettings
        : Option[zio.aws.transcribe.model.ModelSettings.ReadOnly] = scala
      .Option(impl.modelSettings())
      .map(value => zio.aws.transcribe.model.ModelSettings.wrap(value))
    override val jobExecutionSettings
        : Option[zio.aws.transcribe.model.JobExecutionSettings.ReadOnly] = scala
      .Option(impl.jobExecutionSettings())
      .map(value => zio.aws.transcribe.model.JobExecutionSettings.wrap(value))
    override val contentRedaction
        : Option[zio.aws.transcribe.model.ContentRedaction.ReadOnly] = scala
      .Option(impl.contentRedaction())
      .map(value => zio.aws.transcribe.model.ContentRedaction.wrap(value))
    override val identifyLanguage: Option[Boolean] =
      scala.Option(impl.identifyLanguage()).map(value => value: Boolean)
    override val languageOptions
        : Option[List[zio.aws.transcribe.model.LanguageCode]] = scala
      .Option(impl.languageOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transcribe.model.LanguageCode.wrap(item)
        }.toList
      )
    override val identifiedLanguageScore: Option[IdentifiedLanguageScore] =
      scala
        .Option(impl.identifiedLanguageScore())
        .map(value =>
          zio.aws.transcribe.model.primitives.IdentifiedLanguageScore(value)
        )
    override val tags: Option[List[zio.aws.transcribe.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transcribe.model.Tag.wrap(item)
          }.toList
        )
    override val subtitles
        : Option[zio.aws.transcribe.model.SubtitlesOutput.ReadOnly] = scala
      .Option(impl.subtitles())
      .map(value => zio.aws.transcribe.model.SubtitlesOutput.wrap(value))
    override val languageIdSettings: Option[Map[
      zio.aws.transcribe.model.LanguageCode,
      zio.aws.transcribe.model.LanguageIdSettings.ReadOnly
    ]] = scala
      .Option(impl.languageIdSettings())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.transcribe.model.LanguageCode.wrap(
              key
            ) -> zio.aws.transcribe.model.LanguageIdSettings.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.TranscriptionJob
  ): zio.aws.transcribe.model.TranscriptionJob.ReadOnly = new Wrapper(impl)
}
