package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.VocabularyName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteMedicalVocabularyRequest(
    vocabularyName: VocabularyName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.DeleteMedicalVocabularyRequest = {
    import DeleteMedicalVocabularyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.DeleteMedicalVocabularyRequest
      .builder()
      .vocabularyName(VocabularyName.unwrap(vocabularyName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.DeleteMedicalVocabularyRequest.ReadOnly =
    zio.aws.transcribe.model.DeleteMedicalVocabularyRequest
      .wrap(buildAwsValue())
}
object DeleteMedicalVocabularyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.DeleteMedicalVocabularyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.DeleteMedicalVocabularyRequest =
      zio.aws.transcribe.model.DeleteMedicalVocabularyRequest(vocabularyName)
    def vocabularyName: VocabularyName
    def getVocabularyName: ZIO[Any, Nothing, VocabularyName] =
      ZIO.succeed(vocabularyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.DeleteMedicalVocabularyRequest
  ) extends zio.aws.transcribe.model.DeleteMedicalVocabularyRequest.ReadOnly {
    override val vocabularyName: VocabularyName =
      zio.aws.transcribe.model.primitives.VocabularyName(impl.vocabularyName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.DeleteMedicalVocabularyRequest
  ): zio.aws.transcribe.model.DeleteMedicalVocabularyRequest.ReadOnly =
    new Wrapper(impl)
}
