package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateCallAnalyticsCategoryResponse(
    categoryProperties: Option[zio.aws.transcribe.model.CategoryProperties] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.CreateCallAnalyticsCategoryResponse = {
    import CreateCallAnalyticsCategoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.CreateCallAnalyticsCategoryResponse
      .builder()
      .optionallyWith(categoryProperties.map(value => value.buildAwsValue()))(
        _.categoryProperties
      )
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.CreateCallAnalyticsCategoryResponse.ReadOnly =
    zio.aws.transcribe.model.CreateCallAnalyticsCategoryResponse
      .wrap(buildAwsValue())
}
object CreateCallAnalyticsCategoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.CreateCallAnalyticsCategoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.transcribe.model.CreateCallAnalyticsCategoryResponse =
      zio.aws.transcribe.model.CreateCallAnalyticsCategoryResponse(
        categoryProperties.map(value => value.asEditable)
      )
    def categoryProperties
        : Option[zio.aws.transcribe.model.CategoryProperties.ReadOnly]
    def getCategoryProperties: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.CategoryProperties.ReadOnly
    ] = AwsError.unwrapOptionField("categoryProperties", categoryProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.CreateCallAnalyticsCategoryResponse
  ) extends zio.aws.transcribe.model.CreateCallAnalyticsCategoryResponse.ReadOnly {
    override val categoryProperties
        : Option[zio.aws.transcribe.model.CategoryProperties.ReadOnly] = scala
      .Option(impl.categoryProperties())
      .map(value => zio.aws.transcribe.model.CategoryProperties.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.CreateCallAnalyticsCategoryResponse
  ): zio.aws.transcribe.model.CreateCallAnalyticsCategoryResponse.ReadOnly =
    new Wrapper(impl)
}
