package zio.aws.transcribe.model
import scala.jdk.CollectionConverters.*
sealed trait BaseModelName {
  def unwrap: software.amazon.awssdk.services.transcribe.model.BaseModelName
}
object BaseModelName {
  def wrap(
      value: software.amazon.awssdk.services.transcribe.model.BaseModelName
  ): zio.aws.transcribe.model.BaseModelName = value match {
    case software.amazon.awssdk.services.transcribe.model.BaseModelName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transcribe.model.BaseModelName.NARROW_BAND =>
      val r = NarrowBand
      r
    case software.amazon.awssdk.services.transcribe.model.BaseModelName.WIDE_BAND =>
      val r = WideBand
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transcribe.model.BaseModelName {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.BaseModelName =
      software.amazon.awssdk.services.transcribe.model.BaseModelName.UNKNOWN_TO_SDK_VERSION
  }
  case object NarrowBand extends zio.aws.transcribe.model.BaseModelName {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.BaseModelName =
      software.amazon.awssdk.services.transcribe.model.BaseModelName.NARROW_BAND
  }
  case object WideBand extends zio.aws.transcribe.model.BaseModelName {
    override def unwrap
        : software.amazon.awssdk.services.transcribe.model.BaseModelName =
      software.amazon.awssdk.services.transcribe.model.BaseModelName.WIDE_BAND
  }
}
