package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.TimestampMilliseconds
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AbsoluteTimeRange(
    startTime: Option[TimestampMilliseconds] = None,
    endTime: Option[TimestampMilliseconds] = None,
    first: Option[TimestampMilliseconds] = None,
    last: Option[TimestampMilliseconds] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.AbsoluteTimeRange = {
    import AbsoluteTimeRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.AbsoluteTimeRange
      .builder()
      .optionallyWith(
        startTime.map(value =>
          TimestampMilliseconds.unwrap(value): java.lang.Long
        )
      )(_.startTime)
      .optionallyWith(
        endTime.map(value =>
          TimestampMilliseconds.unwrap(value): java.lang.Long
        )
      )(_.endTime)
      .optionallyWith(
        first.map(value => TimestampMilliseconds.unwrap(value): java.lang.Long)
      )(_.first)
      .optionallyWith(
        last.map(value => TimestampMilliseconds.unwrap(value): java.lang.Long)
      )(_.last)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.AbsoluteTimeRange.ReadOnly =
    zio.aws.transcribe.model.AbsoluteTimeRange.wrap(buildAwsValue())
}
object AbsoluteTimeRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.AbsoluteTimeRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.AbsoluteTimeRange =
      zio.aws.transcribe.model.AbsoluteTimeRange(
        startTime.map(value => value),
        endTime.map(value => value),
        first.map(value => value),
        last.map(value => value)
      )
    def startTime: Option[TimestampMilliseconds]
    def endTime: Option[TimestampMilliseconds]
    def first: Option[TimestampMilliseconds]
    def last: Option[TimestampMilliseconds]
    def getStartTime: ZIO[Any, AwsError, TimestampMilliseconds] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, TimestampMilliseconds] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getFirst: ZIO[Any, AwsError, TimestampMilliseconds] =
      AwsError.unwrapOptionField("first", first)
    def getLast: ZIO[Any, AwsError, TimestampMilliseconds] =
      AwsError.unwrapOptionField("last", last)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.AbsoluteTimeRange
  ) extends zio.aws.transcribe.model.AbsoluteTimeRange.ReadOnly {
    override val startTime: Option[TimestampMilliseconds] = scala
      .Option(impl.startTime())
      .map(value =>
        zio.aws.transcribe.model.primitives.TimestampMilliseconds(value)
      )
    override val endTime: Option[TimestampMilliseconds] = scala
      .Option(impl.endTime())
      .map(value =>
        zio.aws.transcribe.model.primitives.TimestampMilliseconds(value)
      )
    override val first: Option[TimestampMilliseconds] = scala
      .Option(impl.first())
      .map(value =>
        zio.aws.transcribe.model.primitives.TimestampMilliseconds(value)
      )
    override val last: Option[TimestampMilliseconds] = scala
      .Option(impl.last())
      .map(value =>
        zio.aws.transcribe.model.primitives.TimestampMilliseconds(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.AbsoluteTimeRange
  ): zio.aws.transcribe.model.AbsoluteTimeRange.ReadOnly = new Wrapper(impl)
}
