package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.{Uri, VocabularyName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateMedicalVocabularyRequest(
    vocabularyName: VocabularyName,
    languageCode: zio.aws.transcribe.model.LanguageCode,
    vocabularyFileUri: Option[Uri] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.UpdateMedicalVocabularyRequest = {
    import UpdateMedicalVocabularyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.UpdateMedicalVocabularyRequest
      .builder()
      .vocabularyName(VocabularyName.unwrap(vocabularyName): java.lang.String)
      .languageCode(languageCode.unwrap)
      .optionallyWith(
        vocabularyFileUri.map(value => Uri.unwrap(value): java.lang.String)
      )(_.vocabularyFileUri)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.UpdateMedicalVocabularyRequest.ReadOnly =
    zio.aws.transcribe.model.UpdateMedicalVocabularyRequest
      .wrap(buildAwsValue())
}
object UpdateMedicalVocabularyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.UpdateMedicalVocabularyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.UpdateMedicalVocabularyRequest =
      zio.aws.transcribe.model.UpdateMedicalVocabularyRequest(
        vocabularyName,
        languageCode,
        vocabularyFileUri.map(value => value)
      )
    def vocabularyName: VocabularyName
    def languageCode: zio.aws.transcribe.model.LanguageCode
    def vocabularyFileUri: Option[Uri]
    def getVocabularyName: ZIO[Any, Nothing, VocabularyName] =
      ZIO.succeed(vocabularyName)
    def getLanguageCode
        : ZIO[Any, Nothing, zio.aws.transcribe.model.LanguageCode] =
      ZIO.succeed(languageCode)
    def getVocabularyFileUri: ZIO[Any, AwsError, Uri] =
      AwsError.unwrapOptionField("vocabularyFileUri", vocabularyFileUri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.UpdateMedicalVocabularyRequest
  ) extends zio.aws.transcribe.model.UpdateMedicalVocabularyRequest.ReadOnly {
    override val vocabularyName: VocabularyName =
      zio.aws.transcribe.model.primitives.VocabularyName(impl.vocabularyName())
    override val languageCode: zio.aws.transcribe.model.LanguageCode =
      zio.aws.transcribe.model.LanguageCode.wrap(impl.languageCode())
    override val vocabularyFileUri: Option[Uri] = scala
      .Option(impl.vocabularyFileUri())
      .map(value => zio.aws.transcribe.model.primitives.Uri(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.UpdateMedicalVocabularyRequest
  ): zio.aws.transcribe.model.UpdateMedicalVocabularyRequest.ReadOnly =
    new Wrapper(impl)
}
