package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.CategoryName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateCallAnalyticsCategoryRequest(
    categoryName: CategoryName,
    rules: Iterable[zio.aws.transcribe.model.Rule]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.UpdateCallAnalyticsCategoryRequest = {
    import UpdateCallAnalyticsCategoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.UpdateCallAnalyticsCategoryRequest
      .builder()
      .categoryName(CategoryName.unwrap(categoryName): java.lang.String)
      .rules(rules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.UpdateCallAnalyticsCategoryRequest.ReadOnly =
    zio.aws.transcribe.model.UpdateCallAnalyticsCategoryRequest
      .wrap(buildAwsValue())
}
object UpdateCallAnalyticsCategoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.UpdateCallAnalyticsCategoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.transcribe.model.UpdateCallAnalyticsCategoryRequest =
      zio.aws.transcribe.model.UpdateCallAnalyticsCategoryRequest(
        categoryName,
        rules.map { item =>
          item.asEditable
        }
      )
    def categoryName: CategoryName
    def rules: List[zio.aws.transcribe.model.Rule.ReadOnly]
    def getCategoryName: ZIO[Any, Nothing, CategoryName] =
      ZIO.succeed(categoryName)
    def getRules
        : ZIO[Any, Nothing, List[zio.aws.transcribe.model.Rule.ReadOnly]] =
      ZIO.succeed(rules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.UpdateCallAnalyticsCategoryRequest
  ) extends zio.aws.transcribe.model.UpdateCallAnalyticsCategoryRequest.ReadOnly {
    override val categoryName: CategoryName =
      zio.aws.transcribe.model.primitives.CategoryName(impl.categoryName())
    override val rules: List[zio.aws.transcribe.model.Rule.ReadOnly] = impl
      .rules()
      .asScala
      .map { item =>
        zio.aws.transcribe.model.Rule.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.UpdateCallAnalyticsCategoryRequest
  ): zio.aws.transcribe.model.UpdateCallAnalyticsCategoryRequest.ReadOnly =
    new Wrapper(impl)
}
