package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.Uri
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SubtitlesOutput(
    formats: Option[Iterable[zio.aws.transcribe.model.SubtitleFormat]] = None,
    subtitleFileUris: Option[Iterable[Uri]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.SubtitlesOutput = {
    import SubtitlesOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.SubtitlesOutput
      .builder()
      .optionallyWith(
        formats.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.formatsWithStrings)
      .optionallyWith(
        subtitleFileUris.map(value =>
          value.map { item =>
            Uri.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subtitleFileUris)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.SubtitlesOutput.ReadOnly =
    zio.aws.transcribe.model.SubtitlesOutput.wrap(buildAwsValue())
}
object SubtitlesOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.SubtitlesOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.SubtitlesOutput =
      zio.aws.transcribe.model.SubtitlesOutput(
        formats.map(value => value),
        subtitleFileUris.map(value => value)
      )
    def formats: Option[List[zio.aws.transcribe.model.SubtitleFormat]]
    def subtitleFileUris: Option[List[Uri]]
    def getFormats
        : ZIO[Any, AwsError, List[zio.aws.transcribe.model.SubtitleFormat]] =
      AwsError.unwrapOptionField("formats", formats)
    def getSubtitleFileUris: ZIO[Any, AwsError, List[Uri]] =
      AwsError.unwrapOptionField("subtitleFileUris", subtitleFileUris)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.SubtitlesOutput
  ) extends zio.aws.transcribe.model.SubtitlesOutput.ReadOnly {
    override val formats
        : Option[List[zio.aws.transcribe.model.SubtitleFormat]] = scala
      .Option(impl.formats())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transcribe.model.SubtitleFormat.wrap(item)
        }.toList
      )
    override val subtitleFileUris: Option[List[Uri]] = scala
      .Option(impl.subtitleFileUris())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transcribe.model.primitives.Uri(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.SubtitlesOutput
  ): zio.aws.transcribe.model.SubtitlesOutput.ReadOnly = new Wrapper(impl)
}
