package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.{
  DataAccessRoleArn,
  KMSKeyId,
  Uri,
  CallAnalyticsJobName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StartCallAnalyticsJobRequest(
    callAnalyticsJobName: CallAnalyticsJobName,
    media: zio.aws.transcribe.model.Media,
    outputLocation: Option[Uri] = None,
    outputEncryptionKMSKeyId: Option[KMSKeyId] = None,
    dataAccessRoleArn: DataAccessRoleArn,
    settings: Option[zio.aws.transcribe.model.CallAnalyticsJobSettings] = None,
    channelDefinitions: Option[
      Iterable[zio.aws.transcribe.model.ChannelDefinition]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.StartCallAnalyticsJobRequest = {
    import StartCallAnalyticsJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.StartCallAnalyticsJobRequest
      .builder()
      .callAnalyticsJobName(
        CallAnalyticsJobName.unwrap(callAnalyticsJobName): java.lang.String
      )
      .media(media.buildAwsValue())
      .optionallyWith(
        outputLocation.map(value => Uri.unwrap(value): java.lang.String)
      )(_.outputLocation)
      .optionallyWith(
        outputEncryptionKMSKeyId.map(value =>
          KMSKeyId.unwrap(value): java.lang.String
        )
      )(_.outputEncryptionKMSKeyId)
      .dataAccessRoleArn(
        DataAccessRoleArn.unwrap(dataAccessRoleArn): java.lang.String
      )
      .optionallyWith(settings.map(value => value.buildAwsValue()))(_.settings)
      .optionallyWith(
        channelDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.channelDefinitions)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.StartCallAnalyticsJobRequest.ReadOnly =
    zio.aws.transcribe.model.StartCallAnalyticsJobRequest.wrap(buildAwsValue())
}
object StartCallAnalyticsJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.StartCallAnalyticsJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.StartCallAnalyticsJobRequest =
      zio.aws.transcribe.model.StartCallAnalyticsJobRequest(
        callAnalyticsJobName,
        media.asEditable,
        outputLocation.map(value => value),
        outputEncryptionKMSKeyId.map(value => value),
        dataAccessRoleArn,
        settings.map(value => value.asEditable),
        channelDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def callAnalyticsJobName: CallAnalyticsJobName
    def media: zio.aws.transcribe.model.Media.ReadOnly
    def outputLocation: Option[Uri]
    def outputEncryptionKMSKeyId: Option[KMSKeyId]
    def dataAccessRoleArn: DataAccessRoleArn
    def settings
        : Option[zio.aws.transcribe.model.CallAnalyticsJobSettings.ReadOnly]
    def channelDefinitions
        : Option[List[zio.aws.transcribe.model.ChannelDefinition.ReadOnly]]
    def getCallAnalyticsJobName: ZIO[Any, Nothing, CallAnalyticsJobName] =
      ZIO.succeed(callAnalyticsJobName)
    def getMedia: ZIO[Any, Nothing, zio.aws.transcribe.model.Media.ReadOnly] =
      ZIO.succeed(media)
    def getOutputLocation: ZIO[Any, AwsError, Uri] =
      AwsError.unwrapOptionField("outputLocation", outputLocation)
    def getOutputEncryptionKMSKeyId: ZIO[Any, AwsError, KMSKeyId] = AwsError
      .unwrapOptionField("outputEncryptionKMSKeyId", outputEncryptionKMSKeyId)
    def getDataAccessRoleArn: ZIO[Any, Nothing, DataAccessRoleArn] =
      ZIO.succeed(dataAccessRoleArn)
    def getSettings: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.CallAnalyticsJobSettings.ReadOnly
    ] = AwsError.unwrapOptionField("settings", settings)
    def getChannelDefinitions: ZIO[Any, AwsError, List[
      zio.aws.transcribe.model.ChannelDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("channelDefinitions", channelDefinitions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.StartCallAnalyticsJobRequest
  ) extends zio.aws.transcribe.model.StartCallAnalyticsJobRequest.ReadOnly {
    override val callAnalyticsJobName: CallAnalyticsJobName =
      zio.aws.transcribe.model.primitives
        .CallAnalyticsJobName(impl.callAnalyticsJobName())
    override val media: zio.aws.transcribe.model.Media.ReadOnly =
      zio.aws.transcribe.model.Media.wrap(impl.media())
    override val outputLocation: Option[Uri] = scala
      .Option(impl.outputLocation())
      .map(value => zio.aws.transcribe.model.primitives.Uri(value))
    override val outputEncryptionKMSKeyId: Option[KMSKeyId] = scala
      .Option(impl.outputEncryptionKMSKeyId())
      .map(value => zio.aws.transcribe.model.primitives.KMSKeyId(value))
    override val dataAccessRoleArn: DataAccessRoleArn =
      zio.aws.transcribe.model.primitives
        .DataAccessRoleArn(impl.dataAccessRoleArn())
    override val settings
        : Option[zio.aws.transcribe.model.CallAnalyticsJobSettings.ReadOnly] =
      scala
        .Option(impl.settings())
        .map(value =>
          zio.aws.transcribe.model.CallAnalyticsJobSettings.wrap(value)
        )
    override val channelDefinitions
        : Option[List[zio.aws.transcribe.model.ChannelDefinition.ReadOnly]] =
      scala
        .Option(impl.channelDefinitions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transcribe.model.ChannelDefinition.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.StartCallAnalyticsJobRequest
  ): zio.aws.transcribe.model.StartCallAnalyticsJobRequest.ReadOnly =
    new Wrapper(impl)
}
