package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.VocabularyName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetMedicalVocabularyRequest(vocabularyName: VocabularyName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.GetMedicalVocabularyRequest = {
    import GetMedicalVocabularyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.GetMedicalVocabularyRequest
      .builder()
      .vocabularyName(VocabularyName.unwrap(vocabularyName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.GetMedicalVocabularyRequest.ReadOnly =
    zio.aws.transcribe.model.GetMedicalVocabularyRequest.wrap(buildAwsValue())
}
object GetMedicalVocabularyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.GetMedicalVocabularyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.GetMedicalVocabularyRequest =
      zio.aws.transcribe.model.GetMedicalVocabularyRequest(vocabularyName)
    def vocabularyName: VocabularyName
    def getVocabularyName: ZIO[Any, Nothing, VocabularyName] =
      ZIO.succeed(vocabularyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.GetMedicalVocabularyRequest
  ) extends zio.aws.transcribe.model.GetMedicalVocabularyRequest.ReadOnly {
    override val vocabularyName: VocabularyName =
      zio.aws.transcribe.model.primitives.VocabularyName(impl.vocabularyName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.GetMedicalVocabularyRequest
  ): zio.aws.transcribe.model.GetMedicalVocabularyRequest.ReadOnly =
    new Wrapper(impl)
}
