package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.CallAnalyticsJobName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetCallAnalyticsJobRequest(
    callAnalyticsJobName: CallAnalyticsJobName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsJobRequest = {
    import GetCallAnalyticsJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsJobRequest
      .builder()
      .callAnalyticsJobName(
        CallAnalyticsJobName.unwrap(callAnalyticsJobName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.GetCallAnalyticsJobRequest.ReadOnly =
    zio.aws.transcribe.model.GetCallAnalyticsJobRequest.wrap(buildAwsValue())
}
object GetCallAnalyticsJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.GetCallAnalyticsJobRequest =
      zio.aws.transcribe.model.GetCallAnalyticsJobRequest(callAnalyticsJobName)
    def callAnalyticsJobName: CallAnalyticsJobName
    def getCallAnalyticsJobName: ZIO[Any, Nothing, CallAnalyticsJobName] =
      ZIO.succeed(callAnalyticsJobName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsJobRequest
  ) extends zio.aws.transcribe.model.GetCallAnalyticsJobRequest.ReadOnly {
    override val callAnalyticsJobName: CallAnalyticsJobName =
      zio.aws.transcribe.model.primitives
        .CallAnalyticsJobName(impl.callAnalyticsJobName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsJobRequest
  ): zio.aws.transcribe.model.GetCallAnalyticsJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
