package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.ModelName
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ModelSettings(languageModelName: Option[ModelName] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.ModelSettings = {
    import ModelSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.ModelSettings
      .builder()
      .optionallyWith(
        languageModelName.map(value =>
          ModelName.unwrap(value): java.lang.String
        )
      )(_.languageModelName)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.ModelSettings.ReadOnly =
    zio.aws.transcribe.model.ModelSettings.wrap(buildAwsValue())
}
object ModelSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.ModelSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.ModelSettings =
      zio.aws.transcribe.model
        .ModelSettings(languageModelName.map(value => value))
    def languageModelName: Option[ModelName]
    def getLanguageModelName: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("languageModelName", languageModelName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.ModelSettings
  ) extends zio.aws.transcribe.model.ModelSettings.ReadOnly {
    override val languageModelName: Option[ModelName] = scala
      .Option(impl.languageModelName())
      .map(value => zio.aws.transcribe.model.primitives.ModelName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.ModelSettings
  ): zio.aws.transcribe.model.ModelSettings.ReadOnly = new Wrapper(impl)
}
