package zio.aws.transcribe.model
import java.lang.Integer
import zio.ZIO
import zio.aws.transcribe.model.primitives.{
  VocabularyName,
  MaxAlternatives,
  MaxSpeakers
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class MedicalTranscriptionSetting(
    showSpeakerLabels: Option[Boolean] = None,
    maxSpeakerLabels: Option[MaxSpeakers] = None,
    channelIdentification: Option[Boolean] = None,
    showAlternatives: Option[Boolean] = None,
    maxAlternatives: Option[MaxAlternatives] = None,
    vocabularyName: Option[VocabularyName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionSetting = {
    import MedicalTranscriptionSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionSetting
      .builder()
      .optionallyWith(showSpeakerLabels.map(value => value: java.lang.Boolean))(
        _.showSpeakerLabels
      )
      .optionallyWith(
        maxSpeakerLabels.map(value => MaxSpeakers.unwrap(value): Integer)
      )(_.maxSpeakerLabels)
      .optionallyWith(
        channelIdentification.map(value => value: java.lang.Boolean)
      )(_.channelIdentification)
      .optionallyWith(showAlternatives.map(value => value: java.lang.Boolean))(
        _.showAlternatives
      )
      .optionallyWith(
        maxAlternatives.map(value => MaxAlternatives.unwrap(value): Integer)
      )(_.maxAlternatives)
      .optionallyWith(
        vocabularyName.map(value =>
          VocabularyName.unwrap(value): java.lang.String
        )
      )(_.vocabularyName)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.MedicalTranscriptionSetting.ReadOnly =
    zio.aws.transcribe.model.MedicalTranscriptionSetting.wrap(buildAwsValue())
}
object MedicalTranscriptionSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.MedicalTranscriptionSetting =
      zio.aws.transcribe.model.MedicalTranscriptionSetting(
        showSpeakerLabels.map(value => value),
        maxSpeakerLabels.map(value => value),
        channelIdentification.map(value => value),
        showAlternatives.map(value => value),
        maxAlternatives.map(value => value),
        vocabularyName.map(value => value)
      )
    def showSpeakerLabels: Option[Boolean]
    def maxSpeakerLabels: Option[MaxSpeakers]
    def channelIdentification: Option[Boolean]
    def showAlternatives: Option[Boolean]
    def maxAlternatives: Option[MaxAlternatives]
    def vocabularyName: Option[VocabularyName]
    def getShowSpeakerLabels: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("showSpeakerLabels", showSpeakerLabels)
    def getMaxSpeakerLabels: ZIO[Any, AwsError, MaxSpeakers] =
      AwsError.unwrapOptionField("maxSpeakerLabels", maxSpeakerLabels)
    def getChannelIdentification: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("channelIdentification", channelIdentification)
    def getShowAlternatives: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("showAlternatives", showAlternatives)
    def getMaxAlternatives: ZIO[Any, AwsError, MaxAlternatives] =
      AwsError.unwrapOptionField("maxAlternatives", maxAlternatives)
    def getVocabularyName: ZIO[Any, AwsError, VocabularyName] =
      AwsError.unwrapOptionField("vocabularyName", vocabularyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionSetting
  ) extends zio.aws.transcribe.model.MedicalTranscriptionSetting.ReadOnly {
    override val showSpeakerLabels: Option[Boolean] =
      scala.Option(impl.showSpeakerLabels()).map(value => value: Boolean)
    override val maxSpeakerLabels: Option[MaxSpeakers] = scala
      .Option(impl.maxSpeakerLabels())
      .map(value => zio.aws.transcribe.model.primitives.MaxSpeakers(value))
    override val channelIdentification: Option[Boolean] =
      scala.Option(impl.channelIdentification()).map(value => value: Boolean)
    override val showAlternatives: Option[Boolean] =
      scala.Option(impl.showAlternatives()).map(value => value: Boolean)
    override val maxAlternatives: Option[MaxAlternatives] = scala
      .Option(impl.maxAlternatives())
      .map(value => zio.aws.transcribe.model.primitives.MaxAlternatives(value))
    override val vocabularyName: Option[VocabularyName] = scala
      .Option(impl.vocabularyName())
      .map(value => zio.aws.transcribe.model.primitives.VocabularyName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionSetting
  ): zio.aws.transcribe.model.MedicalTranscriptionSetting.ReadOnly =
    new Wrapper(impl)
}
