package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.{
  FailureReason,
  DateTime,
  TranscriptionJobName
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class MedicalTranscriptionJobSummary(
    medicalTranscriptionJobName: Option[TranscriptionJobName] = None,
    creationTime: Option[DateTime] = None,
    startTime: Option[DateTime] = None,
    completionTime: Option[DateTime] = None,
    languageCode: Option[zio.aws.transcribe.model.LanguageCode] = None,
    transcriptionJobStatus: Option[
      zio.aws.transcribe.model.TranscriptionJobStatus
    ] = None,
    failureReason: Option[FailureReason] = None,
    outputLocationType: Option[zio.aws.transcribe.model.OutputLocationType] =
      None,
    specialty: Option[zio.aws.transcribe.model.Specialty] = None,
    contentIdentificationType: Option[
      zio.aws.transcribe.model.MedicalContentIdentificationType
    ] = None,
    `type`: Option[zio.aws.transcribe.model.Type] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionJobSummary = {
    import MedicalTranscriptionJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionJobSummary
      .builder()
      .optionallyWith(
        medicalTranscriptionJobName.map(value =>
          TranscriptionJobName.unwrap(value): java.lang.String
        )
      )(_.medicalTranscriptionJobName)
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(startTime.map(value => DateTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(
        completionTime.map(value => DateTime.unwrap(value): Instant)
      )(_.completionTime)
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(transcriptionJobStatus.map(value => value.unwrap))(
        _.transcriptionJobStatus
      )
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(outputLocationType.map(value => value.unwrap))(
        _.outputLocationType
      )
      .optionallyWith(specialty.map(value => value.unwrap))(_.specialty)
      .optionallyWith(contentIdentificationType.map(value => value.unwrap))(
        _.contentIdentificationType
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.MedicalTranscriptionJobSummary.ReadOnly =
    zio.aws.transcribe.model.MedicalTranscriptionJobSummary
      .wrap(buildAwsValue())
}
object MedicalTranscriptionJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.MedicalTranscriptionJobSummary =
      zio.aws.transcribe.model.MedicalTranscriptionJobSummary(
        medicalTranscriptionJobName.map(value => value),
        creationTime.map(value => value),
        startTime.map(value => value),
        completionTime.map(value => value),
        languageCode.map(value => value),
        transcriptionJobStatus.map(value => value),
        failureReason.map(value => value),
        outputLocationType.map(value => value),
        specialty.map(value => value),
        contentIdentificationType.map(value => value),
        `type`.map(value => value)
      )
    def medicalTranscriptionJobName: Option[TranscriptionJobName]
    def creationTime: Option[DateTime]
    def startTime: Option[DateTime]
    def completionTime: Option[DateTime]
    def languageCode: Option[zio.aws.transcribe.model.LanguageCode]
    def transcriptionJobStatus
        : Option[zio.aws.transcribe.model.TranscriptionJobStatus]
    def failureReason: Option[FailureReason]
    def outputLocationType: Option[zio.aws.transcribe.model.OutputLocationType]
    def specialty: Option[zio.aws.transcribe.model.Specialty]
    def contentIdentificationType
        : Option[zio.aws.transcribe.model.MedicalContentIdentificationType]
    def `type`: Option[zio.aws.transcribe.model.Type]
    def getMedicalTranscriptionJobName
        : ZIO[Any, AwsError, TranscriptionJobName] = AwsError.unwrapOptionField(
      "medicalTranscriptionJobName",
      medicalTranscriptionJobName
    )
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getCompletionTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("completionTime", completionTime)
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.transcribe.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getTranscriptionJobStatus
        : ZIO[Any, AwsError, zio.aws.transcribe.model.TranscriptionJobStatus] =
      AwsError.unwrapOptionField(
        "transcriptionJobStatus",
        transcriptionJobStatus
      )
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getOutputLocationType
        : ZIO[Any, AwsError, zio.aws.transcribe.model.OutputLocationType] =
      AwsError.unwrapOptionField("outputLocationType", outputLocationType)
    def getSpecialty: ZIO[Any, AwsError, zio.aws.transcribe.model.Specialty] =
      AwsError.unwrapOptionField("specialty", specialty)
    def getContentIdentificationType: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.MedicalContentIdentificationType
    ] = AwsError.unwrapOptionField(
      "contentIdentificationType",
      contentIdentificationType
    )
    def getType: ZIO[Any, AwsError, zio.aws.transcribe.model.Type] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionJobSummary
  ) extends zio.aws.transcribe.model.MedicalTranscriptionJobSummary.ReadOnly {
    override val medicalTranscriptionJobName: Option[TranscriptionJobName] =
      scala
        .Option(impl.medicalTranscriptionJobName())
        .map(value =>
          zio.aws.transcribe.model.primitives.TranscriptionJobName(value)
        )
    override val creationTime: Option[DateTime] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val startTime: Option[DateTime] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val completionTime: Option[DateTime] = scala
      .Option(impl.completionTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val languageCode: Option[zio.aws.transcribe.model.LanguageCode] =
      scala
        .Option(impl.languageCode())
        .map(value => zio.aws.transcribe.model.LanguageCode.wrap(value))
    override val transcriptionJobStatus
        : Option[zio.aws.transcribe.model.TranscriptionJobStatus] = scala
      .Option(impl.transcriptionJobStatus())
      .map(value => zio.aws.transcribe.model.TranscriptionJobStatus.wrap(value))
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.transcribe.model.primitives.FailureReason(value))
    override val outputLocationType
        : Option[zio.aws.transcribe.model.OutputLocationType] = scala
      .Option(impl.outputLocationType())
      .map(value => zio.aws.transcribe.model.OutputLocationType.wrap(value))
    override val specialty: Option[zio.aws.transcribe.model.Specialty] = scala
      .Option(impl.specialty())
      .map(value => zio.aws.transcribe.model.Specialty.wrap(value))
    override val contentIdentificationType
        : Option[zio.aws.transcribe.model.MedicalContentIdentificationType] =
      scala
        .Option(impl.contentIdentificationType())
        .map(value =>
          zio.aws.transcribe.model.MedicalContentIdentificationType.wrap(value)
        )
    override val `type`: Option[zio.aws.transcribe.model.Type] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.transcribe.model.Type.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionJobSummary
  ): zio.aws.transcribe.model.MedicalTranscriptionJobSummary.ReadOnly =
    new Wrapper(impl)
}
