package zio.aws.transcribe.model
import java.lang.Integer
import zio.ZIO
import zio.aws.transcribe.model.primitives.{
  VocabularyFilterName,
  MaxResults,
  NextToken
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListVocabularyFiltersRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None,
    nameContains: Option[VocabularyFilterName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersRequest = {
    import ListVocabularyFiltersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nameContains.map(value =>
          VocabularyFilterName.unwrap(value): java.lang.String
        )
      )(_.nameContains)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.ListVocabularyFiltersRequest.ReadOnly =
    zio.aws.transcribe.model.ListVocabularyFiltersRequest.wrap(buildAwsValue())
}
object ListVocabularyFiltersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.ListVocabularyFiltersRequest =
      zio.aws.transcribe.model.ListVocabularyFiltersRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        nameContains.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def nameContains: Option[VocabularyFilterName]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNameContains: ZIO[Any, AwsError, VocabularyFilterName] =
      AwsError.unwrapOptionField("nameContains", nameContains)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersRequest
  ) extends zio.aws.transcribe.model.ListVocabularyFiltersRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.transcribe.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.transcribe.model.primitives.MaxResults(value))
    override val nameContains: Option[VocabularyFilterName] = scala
      .Option(impl.nameContains())
      .map(value =>
        zio.aws.transcribe.model.primitives.VocabularyFilterName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersRequest
  ): zio.aws.transcribe.model.ListVocabularyFiltersRequest.ReadOnly =
    new Wrapper(impl)
}
