package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListMedicalTranscriptionJobsResponse(
    status: Option[zio.aws.transcribe.model.TranscriptionJobStatus] = None,
    nextToken: Option[NextToken] = None,
    medicalTranscriptionJobSummaries: Option[
      Iterable[zio.aws.transcribe.model.MedicalTranscriptionJobSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsResponse = {
    import ListMedicalTranscriptionJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsResponse
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        medicalTranscriptionJobSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.medicalTranscriptionJobSummaries)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.ListMedicalTranscriptionJobsResponse.ReadOnly =
    zio.aws.transcribe.model.ListMedicalTranscriptionJobsResponse
      .wrap(buildAwsValue())
}
object ListMedicalTranscriptionJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.transcribe.model.ListMedicalTranscriptionJobsResponse =
      zio.aws.transcribe.model.ListMedicalTranscriptionJobsResponse(
        status.map(value => value),
        nextToken.map(value => value),
        medicalTranscriptionJobSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def status: Option[zio.aws.transcribe.model.TranscriptionJobStatus]
    def nextToken: Option[NextToken]
    def medicalTranscriptionJobSummaries: Option[
      List[zio.aws.transcribe.model.MedicalTranscriptionJobSummary.ReadOnly]
    ]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.transcribe.model.TranscriptionJobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMedicalTranscriptionJobSummaries: ZIO[Any, AwsError, List[
      zio.aws.transcribe.model.MedicalTranscriptionJobSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "medicalTranscriptionJobSummaries",
      medicalTranscriptionJobSummaries
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsResponse
  ) extends zio.aws.transcribe.model.ListMedicalTranscriptionJobsResponse.ReadOnly {
    override val status
        : Option[zio.aws.transcribe.model.TranscriptionJobStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.transcribe.model.TranscriptionJobStatus.wrap(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.transcribe.model.primitives.NextToken(value))
    override val medicalTranscriptionJobSummaries: Option[
      List[zio.aws.transcribe.model.MedicalTranscriptionJobSummary.ReadOnly]
    ] = scala
      .Option(impl.medicalTranscriptionJobSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transcribe.model.MedicalTranscriptionJobSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsResponse
  ): zio.aws.transcribe.model.ListMedicalTranscriptionJobsResponse.ReadOnly =
    new Wrapper(impl)
}
