package zio.aws.transcribe.model
import java.lang.Integer
import zio.ZIO
import zio.aws.transcribe.model.primitives.{MaxResults, NextToken, ModelName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListLanguageModelsRequest(
    statusEquals: Option[zio.aws.transcribe.model.ModelStatus] = None,
    nameContains: Option[ModelName] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.ListLanguageModelsRequest = {
    import ListLanguageModelsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.ListLanguageModelsRequest
      .builder()
      .optionallyWith(statusEquals.map(value => value.unwrap))(_.statusEquals)
      .optionallyWith(
        nameContains.map(value => ModelName.unwrap(value): java.lang.String)
      )(_.nameContains)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.ListLanguageModelsRequest.ReadOnly =
    zio.aws.transcribe.model.ListLanguageModelsRequest.wrap(buildAwsValue())
}
object ListLanguageModelsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.ListLanguageModelsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.ListLanguageModelsRequest =
      zio.aws.transcribe.model.ListLanguageModelsRequest(
        statusEquals.map(value => value),
        nameContains.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def statusEquals: Option[zio.aws.transcribe.model.ModelStatus]
    def nameContains: Option[ModelName]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getStatusEquals
        : ZIO[Any, AwsError, zio.aws.transcribe.model.ModelStatus] =
      AwsError.unwrapOptionField("statusEquals", statusEquals)
    def getNameContains: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.ListLanguageModelsRequest
  ) extends zio.aws.transcribe.model.ListLanguageModelsRequest.ReadOnly {
    override val statusEquals: Option[zio.aws.transcribe.model.ModelStatus] =
      scala
        .Option(impl.statusEquals())
        .map(value => zio.aws.transcribe.model.ModelStatus.wrap(value))
    override val nameContains: Option[ModelName] = scala
      .Option(impl.nameContains())
      .map(value => zio.aws.transcribe.model.primitives.ModelName(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.transcribe.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.transcribe.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.ListLanguageModelsRequest
  ): zio.aws.transcribe.model.ListLanguageModelsRequest.ReadOnly = new Wrapper(
    impl
  )
}
