package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListCallAnalyticsJobsResponse(
    status: Option[zio.aws.transcribe.model.CallAnalyticsJobStatus] = None,
    nextToken: Option[NextToken] = None,
    callAnalyticsJobSummaries: Option[
      Iterable[zio.aws.transcribe.model.CallAnalyticsJobSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsResponse = {
    import ListCallAnalyticsJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsResponse
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        callAnalyticsJobSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.callAnalyticsJobSummaries)
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.ListCallAnalyticsJobsResponse.ReadOnly =
    zio.aws.transcribe.model.ListCallAnalyticsJobsResponse.wrap(buildAwsValue())
}
object ListCallAnalyticsJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.ListCallAnalyticsJobsResponse =
      zio.aws.transcribe.model.ListCallAnalyticsJobsResponse(
        status.map(value => value),
        nextToken.map(value => value),
        callAnalyticsJobSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def status: Option[zio.aws.transcribe.model.CallAnalyticsJobStatus]
    def nextToken: Option[NextToken]
    def callAnalyticsJobSummaries: Option[
      List[zio.aws.transcribe.model.CallAnalyticsJobSummary.ReadOnly]
    ]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.transcribe.model.CallAnalyticsJobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getCallAnalyticsJobSummaries: ZIO[Any, AwsError, List[
      zio.aws.transcribe.model.CallAnalyticsJobSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "callAnalyticsJobSummaries",
      callAnalyticsJobSummaries
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsResponse
  ) extends zio.aws.transcribe.model.ListCallAnalyticsJobsResponse.ReadOnly {
    override val status
        : Option[zio.aws.transcribe.model.CallAnalyticsJobStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.transcribe.model.CallAnalyticsJobStatus.wrap(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.transcribe.model.primitives.NextToken(value))
    override val callAnalyticsJobSummaries: Option[
      List[zio.aws.transcribe.model.CallAnalyticsJobSummary.ReadOnly]
    ] = scala
      .Option(impl.callAnalyticsJobSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transcribe.model.CallAnalyticsJobSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.ListCallAnalyticsJobsResponse
  ): zio.aws.transcribe.model.ListCallAnalyticsJobsResponse.ReadOnly =
    new Wrapper(impl)
}
