package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.transcribe.model.primitives.{FailureReason, DateTime, ModelName}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class LanguageModel(
    modelName: Option[ModelName] = None,
    createTime: Option[DateTime] = None,
    lastModifiedTime: Option[DateTime] = None,
    languageCode: Option[zio.aws.transcribe.model.CLMLanguageCode] = None,
    baseModelName: Option[zio.aws.transcribe.model.BaseModelName] = None,
    modelStatus: Option[zio.aws.transcribe.model.ModelStatus] = None,
    upgradeAvailability: Option[Boolean] = None,
    failureReason: Option[FailureReason] = None,
    inputDataConfig: Option[zio.aws.transcribe.model.InputDataConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.LanguageModel = {
    import LanguageModel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.LanguageModel
      .builder()
      .optionallyWith(
        modelName.map(value => ModelName.unwrap(value): java.lang.String)
      )(_.modelName)
      .optionallyWith(createTime.map(value => DateTime.unwrap(value): Instant))(
        _.createTime
      )
      .optionallyWith(
        lastModifiedTime.map(value => DateTime.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(baseModelName.map(value => value.unwrap))(_.baseModelName)
      .optionallyWith(modelStatus.map(value => value.unwrap))(_.modelStatus)
      .optionallyWith(
        upgradeAvailability.map(value => value: java.lang.Boolean)
      )(_.upgradeAvailability)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(inputDataConfig.map(value => value.buildAwsValue()))(
        _.inputDataConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.LanguageModel.ReadOnly =
    zio.aws.transcribe.model.LanguageModel.wrap(buildAwsValue())
}
object LanguageModel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.LanguageModel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.LanguageModel =
      zio.aws.transcribe.model.LanguageModel(
        modelName.map(value => value),
        createTime.map(value => value),
        lastModifiedTime.map(value => value),
        languageCode.map(value => value),
        baseModelName.map(value => value),
        modelStatus.map(value => value),
        upgradeAvailability.map(value => value),
        failureReason.map(value => value),
        inputDataConfig.map(value => value.asEditable)
      )
    def modelName: Option[ModelName]
    def createTime: Option[DateTime]
    def lastModifiedTime: Option[DateTime]
    def languageCode: Option[zio.aws.transcribe.model.CLMLanguageCode]
    def baseModelName: Option[zio.aws.transcribe.model.BaseModelName]
    def modelStatus: Option[zio.aws.transcribe.model.ModelStatus]
    def upgradeAvailability: Option[Boolean]
    def failureReason: Option[FailureReason]
    def inputDataConfig
        : Option[zio.aws.transcribe.model.InputDataConfig.ReadOnly]
    def getModelName: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("modelName", modelName)
    def getCreateTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getLastModifiedTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.transcribe.model.CLMLanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getBaseModelName
        : ZIO[Any, AwsError, zio.aws.transcribe.model.BaseModelName] =
      AwsError.unwrapOptionField("baseModelName", baseModelName)
    def getModelStatus
        : ZIO[Any, AwsError, zio.aws.transcribe.model.ModelStatus] =
      AwsError.unwrapOptionField("modelStatus", modelStatus)
    def getUpgradeAvailability: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("upgradeAvailability", upgradeAvailability)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getInputDataConfig: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.InputDataConfig.ReadOnly
    ] = AwsError.unwrapOptionField("inputDataConfig", inputDataConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.LanguageModel
  ) extends zio.aws.transcribe.model.LanguageModel.ReadOnly {
    override val modelName: Option[ModelName] = scala
      .Option(impl.modelName())
      .map(value => zio.aws.transcribe.model.primitives.ModelName(value))
    override val createTime: Option[DateTime] = scala
      .Option(impl.createTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val lastModifiedTime: Option[DateTime] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.transcribe.model.primitives.DateTime(value))
    override val languageCode
        : Option[zio.aws.transcribe.model.CLMLanguageCode] = scala
      .Option(impl.languageCode())
      .map(value => zio.aws.transcribe.model.CLMLanguageCode.wrap(value))
    override val baseModelName: Option[zio.aws.transcribe.model.BaseModelName] =
      scala
        .Option(impl.baseModelName())
        .map(value => zio.aws.transcribe.model.BaseModelName.wrap(value))
    override val modelStatus: Option[zio.aws.transcribe.model.ModelStatus] =
      scala
        .Option(impl.modelStatus())
        .map(value => zio.aws.transcribe.model.ModelStatus.wrap(value))
    override val upgradeAvailability: Option[Boolean] =
      scala.Option(impl.upgradeAvailability()).map(value => value: Boolean)
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.transcribe.model.primitives.FailureReason(value))
    override val inputDataConfig
        : Option[zio.aws.transcribe.model.InputDataConfig.ReadOnly] = scala
      .Option(impl.inputDataConfig())
      .map(value => zio.aws.transcribe.model.InputDataConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.LanguageModel
  ): zio.aws.transcribe.model.LanguageModel.ReadOnly = new Wrapper(impl)
}
