package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetCallAnalyticsCategoryResponse(
    categoryProperties: Option[zio.aws.transcribe.model.CategoryProperties] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsCategoryResponse = {
    import GetCallAnalyticsCategoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsCategoryResponse
      .builder()
      .optionallyWith(categoryProperties.map(value => value.buildAwsValue()))(
        _.categoryProperties
      )
      .build()
  }
  def asReadOnly
      : zio.aws.transcribe.model.GetCallAnalyticsCategoryResponse.ReadOnly =
    zio.aws.transcribe.model.GetCallAnalyticsCategoryResponse
      .wrap(buildAwsValue())
}
object GetCallAnalyticsCategoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsCategoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.GetCallAnalyticsCategoryResponse =
      zio.aws.transcribe.model.GetCallAnalyticsCategoryResponse(
        categoryProperties.map(value => value.asEditable)
      )
    def categoryProperties
        : Option[zio.aws.transcribe.model.CategoryProperties.ReadOnly]
    def getCategoryProperties: ZIO[
      Any,
      AwsError,
      zio.aws.transcribe.model.CategoryProperties.ReadOnly
    ] = AwsError.unwrapOptionField("categoryProperties", categoryProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsCategoryResponse
  ) extends zio.aws.transcribe.model.GetCallAnalyticsCategoryResponse.ReadOnly {
    override val categoryProperties
        : Option[zio.aws.transcribe.model.CategoryProperties.ReadOnly] = scala
      .Option(impl.categoryProperties())
      .map(value => zio.aws.transcribe.model.CategoryProperties.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsCategoryResponse
  ): zio.aws.transcribe.model.GetCallAnalyticsCategoryResponse.ReadOnly =
    new Wrapper(impl)
}
