package zio.aws.transcribe.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ContentRedaction(
    redactionType: zio.aws.transcribe.model.RedactionType,
    redactionOutput: zio.aws.transcribe.model.RedactionOutput
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transcribe.model.ContentRedaction = {
    import ContentRedaction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transcribe.model.ContentRedaction
      .builder()
      .redactionType(redactionType.unwrap)
      .redactionOutput(redactionOutput.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.transcribe.model.ContentRedaction.ReadOnly =
    zio.aws.transcribe.model.ContentRedaction.wrap(buildAwsValue())
}
object ContentRedaction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transcribe.model.ContentRedaction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transcribe.model.ContentRedaction =
      zio.aws.transcribe.model.ContentRedaction(redactionType, redactionOutput)
    def redactionType: zio.aws.transcribe.model.RedactionType
    def redactionOutput: zio.aws.transcribe.model.RedactionOutput
    def getRedactionType
        : ZIO[Any, Nothing, zio.aws.transcribe.model.RedactionType] =
      ZIO.succeed(redactionType)
    def getRedactionOutput
        : ZIO[Any, Nothing, zio.aws.transcribe.model.RedactionOutput] =
      ZIO.succeed(redactionOutput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transcribe.model.ContentRedaction
  ) extends zio.aws.transcribe.model.ContentRedaction.ReadOnly {
    override val redactionType: zio.aws.transcribe.model.RedactionType =
      zio.aws.transcribe.model.RedactionType.wrap(impl.redactionType())
    override val redactionOutput: zio.aws.transcribe.model.RedactionOutput =
      zio.aws.transcribe.model.RedactionOutput.wrap(impl.redactionOutput())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transcribe.model.ContentRedaction
  ): zio.aws.transcribe.model.ContentRedaction.ReadOnly = new Wrapper(impl)
}
