package zio.aws.timestreamwrite.model
import scala.jdk.CollectionConverters.*
sealed trait PartitionKeyType {
  def unwrap
      : software.amazon.awssdk.services.timestreamwrite.model.PartitionKeyType
}
object PartitionKeyType {
  def wrap(
      value: software.amazon.awssdk.services.timestreamwrite.model.PartitionKeyType
  ): zio.aws.timestreamwrite.model.PartitionKeyType = value match {
    case software.amazon.awssdk.services.timestreamwrite.model.PartitionKeyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.timestreamwrite.model.PartitionKeyType.DIMENSION =>
      val r = DIMENSION
      r
    case software.amazon.awssdk.services.timestreamwrite.model.PartitionKeyType.MEASURE =>
      val r = MEASURE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.timestreamwrite.model.PartitionKeyType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.PartitionKeyType =
      software.amazon.awssdk.services.timestreamwrite.model.PartitionKeyType.UNKNOWN_TO_SDK_VERSION
  }
  case object DIMENSION extends zio.aws.timestreamwrite.model.PartitionKeyType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.PartitionKeyType =
      software.amazon.awssdk.services.timestreamwrite.model.PartitionKeyType.DIMENSION
  }
  case object MEASURE extends zio.aws.timestreamwrite.model.PartitionKeyType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.PartitionKeyType =
      software.amazon.awssdk.services.timestreamwrite.model.PartitionKeyType.MEASURE
  }
}
