package zio.aws.timestreamwrite.model
import zio.aws.timestreamwrite.model.primitives.SchemaName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PartitionKey(
    `type`: zio.aws.timestreamwrite.model.PartitionKeyType,
    name: Optional[SchemaName] = Optional.Absent,
    enforcementInRecord: Optional[
      zio.aws.timestreamwrite.model.PartitionKeyEnforcementLevel
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.PartitionKey = {
    import PartitionKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.PartitionKey
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(
        name.map(value => SchemaName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(enforcementInRecord.map(value => value.unwrap))(
        _.enforcementInRecord
      )
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.PartitionKey.ReadOnly =
    zio.aws.timestreamwrite.model.PartitionKey.wrap(buildAwsValue())
}
object PartitionKey {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.PartitionKey
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.PartitionKey =
      zio.aws.timestreamwrite.model.PartitionKey(
        `type`,
        name.map(value => value),
        enforcementInRecord.map(value => value)
      )
    def `type`: zio.aws.timestreamwrite.model.PartitionKeyType
    def name: Optional[SchemaName]
    def enforcementInRecord
        : Optional[zio.aws.timestreamwrite.model.PartitionKeyEnforcementLevel]
    def getType
        : ZIO[Any, Nothing, zio.aws.timestreamwrite.model.PartitionKeyType] =
      ZIO.succeed(`type`)
    def getName: ZIO[Any, AwsError, SchemaName] =
      AwsError.unwrapOptionField("name", name)
    def getEnforcementInRecord: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamwrite.model.PartitionKeyEnforcementLevel
    ] = AwsError.unwrapOptionField("enforcementInRecord", enforcementInRecord)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.PartitionKey
  ) extends zio.aws.timestreamwrite.model.PartitionKey.ReadOnly {
    override val `type`: zio.aws.timestreamwrite.model.PartitionKeyType =
      zio.aws.timestreamwrite.model.PartitionKeyType.wrap(impl.`type`())
    override val name: Optional[SchemaName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.timestreamwrite.model.primitives.SchemaName(value))
    override val enforcementInRecord
        : Optional[zio.aws.timestreamwrite.model.PartitionKeyEnforcementLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enforcementInRecord())
        .map(value =>
          zio.aws.timestreamwrite.model.PartitionKeyEnforcementLevel.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.PartitionKey
  ): zio.aws.timestreamwrite.model.PartitionKey.ReadOnly = new Wrapper(impl)
}
